<?php


namespace Actigraph\CarteBundle\Controller;

use Actigraph\CarteBundle\Entity\Ligne;
use Actigraph\CarteBundle\Entity\Panneau;
use Actigraph\CarteBundle\Entity\Poi;
use Actigraph\CarteBundle\Entity\StopArea;
use Actigraph\CarteBundle\Entity\Ville;
use Actigraph\CarteBundle\Service\BackObj\RemoteInfoTrafic;
use Actigraph\CarteBundle\Service\BackObj\RemoteStopLines;
use Actigraph\CarteBundle\Service\BackService;
use Actigraph\CarteBundle\Service\ReferentielService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;


/**
 * @Route("/referentiel")
 */
class ReferentielController extends AbstractController
{

    /**
     * @Route("/stoparea", name="referentiel_stoparea", options={"expose"=true})
     */
    public function getStopArea(Request $request,ReferentielService $referentielService){
        $response = new JsonResponse();

        $stopareasDb = $referentielService->listStoparea();
        $stopareasArray = [];
        /** @var StopArea $item */
        foreach ($stopareasDb as $item){
            $stopareasArray[]=$item->toArray();
        }
        $response->setData(
            $stopareasArray
        );

        return $response;
    }

    /**
     * @Route("/stopareabyid/{id}", name="referentiel_stopareabyid", options={"expose"=true})
     */
    public function getStopAreaById(Request $request,ReferentielService $referentielService, $id){
        $response = new JsonResponse();

        /** @var StopArea $stoparea */
        $stoparea = $referentielService->getStopArea($id);

        $response->setData(
            $stoparea->toArray()
        );

        return $response;
    }

    /**
     * @Route("/panneaux", name="referentiel_panneaux", options={"expose"=true})
     */
    public function getPanneaux(Request $request,ReferentielService $referentielService){
        $response = new JsonResponse();
        $entityManager = $this->getDoctrine()->getManager();

        $panneauxDb = $referentielService->listPanneaux();
        $panneauxArray = [];
        /** @var Panneau $item */
        foreach ($panneauxDb as $item){
            if($item->getFileHeigth() == 0 || $item->getFileWidth() == 0){

                $path = "../public/img/panneaux/".$item->getFileName();
                if(file_exists($path)) {
                    list($width, $height) = @getimagesize($path);
                    $item->setFileHeigth($height);
                    $item->setFileWidth($width);
                    $entityManager->persist($item);
                    $entityManager->flush();

                }
            }
            $panneauxArray[]=$item->toArray();
        }
        $response->setData(
            $panneauxArray
        );

        return $response;
    }

    /**
     * @Route("/ville", name="referentiel_ville", options={"expose"=true})
     */
    public function getVille(Request $request,ReferentielService $referentielService){
        $response = new JsonResponse();

        $villeDb = $referentielService->listVille();
        $villeArray = [];
        /** @var Ville $item */
        foreach ($villeDb as $item){
            $villeArray[]=$item->toArray();
        }
        $response->setData(
            $villeArray
        );

        return $response;
    }

    /**
     * @Route("/lignes", name="referentiel_lignes", options={"expose"=true})
     */
    public function getLignes(Request $request,ReferentielService $referentielService){
        $response = new JsonResponse();

        $ligneDb = $referentielService->listLigne();
        $ligneArray = [];
        /** @var Ligne $item */
        foreach ($ligneDb as $item){
            $ligneArray[]=$item->toArray();
        }

        $response->setData(
            $ligneArray
        );

        return $response;
    }

    /**
     * @Route("/infostrafic", name="referentiel_infotrafic", options={"expose"=true})
     */
    public function getInfoTraffic(Request $request,BackService $backService){
        $response = new JsonResponse();

        $pertubsRemote = $backService->listCurrentInfosTrafics();
        $pertubsArray = [];
        if(is_array($pertubsRemote) && count($pertubsRemote)>0){
            /** @var RemoteInfoTrafic $item */
            foreach ($pertubsRemote as $item){
                $pertubsArray[]=$item->toArray();
            }
        }
        $response->setData(
            $pertubsArray
        );

        return $response;
    }

    /**
     * @Route("/poitypes", name="referentiel_poitypes", options={"expose"=true})
     */
    public function getPoiTypes(Request $request,ReferentielService $referentielService){
        $response = new JsonResponse();

        $ligneDb = $referentielService->listPoiTypes();
        $ligneArray = [];
        /** @var Ligne $item */
        foreach ($ligneDb as $item){
            $ligneArray[]=$item->toArray();
        }
        $response->setData(
            $ligneArray
        );

        return $response;
    }

    /**
     * @Route("/poitypes/{id}/pois", requirements={"id": "\d+"}, name="referentiel_poibypoitype", options={"expose"=true})
     */
    public function getPoisFromPoiType(Request $request,ReferentielService $referentielService,BackService $backService,$id){
        $response = new JsonResponse();

        $ligneDb = $referentielService->listPoiByTypeId($id);
        $ligneDbUpdated = $backService->listUpdatedPoiExtraDataByTypeExternalCode($ligneDb, $id, []);
        if(!$ligneDbUpdated)
            $ligneDbUpdated = $ligneDb;
        //TODO utilation de backservice afin de mettre à jour les infos temps réel de l'ensemble des POIs (si j'ai une réponse différente de false)
        $ligneArray = [];
        /** @var Ligne $item */
        foreach ($ligneDbUpdated as $item){
            $ligneArray[]=$item->toArray();
        }
        $response->setData(
            $ligneArray
        );

        return $response;
    }

    /**
     * @Route("/poi/{id}", requirements={"id": "\d+"}, name="referentiel_poi", options={"expose"=true})
     */
    public function getPoisExtra(Request $request,ReferentielService $referentielService,BackService $backService,$id){
        $response = new JsonResponse();

        $poi = $referentielService->getPoi($id);
        /** @var Poi $poi */
        $poiUpdated = $backService->updatePoiExtraData($poi);
        if($poiUpdated != false)
            $poi = $poiUpdated;

        $response->setData(
            $poi->toArray()
        );

        return $response;
    }

    /**
     * @Route("/autocomplete", name="referentiel_autocomplete", options={"expose"=true})
     */
    public function autocomplete(Request $request,BackService $backService,ReferentielService $referentielService){
        $text = $request->query->get("q","");
        $source = $request->query->get("s","local");
        $suggestionsArray=[];
        $response = new JsonResponse();
        $entityManager = $this->getDoctrine()->getManager();

        if($source == "local") {
            $suggestions = $referentielService->autocomplete($text);
        } else {
            $suggestions = $backService->autocomplete($text);
        }
        $all_name = [];
        if(count($suggestions)>0){
            /** @var Ligne $item */
            foreach ($suggestions as $suggestion){
                $suggest = $suggestion->toArray();
                $suggest["id"] = "";
                if($source == "local") {
                    if($suggestion->getType() == "0") {
                        $stop = $entityManager->getRepository(StopArea::class)->findOneBy(array("externalCode"=>$suggestion->getExternalCode()));
                        $suggest["id"] = $stop->getId();
                    }
                }

                if(!in_array( $suggest["name"]."|".$suggestion->getType(), $all_name)){
                    array_push($all_name, $suggest["name"]."|".$suggestion->getType());
                    $suggestionsArray[]=$suggest;
                }
            }
        }

        $response->setData(
            $suggestionsArray
        );

        return $response;
    }

    /**
     * @Route("/getstoplines", name="referentiel_getstoplines", options={"expose"=true})
     */
    public function getStopLines(Request $request,BackService $backService,ReferentielService $referentielService){
        $text = $request->query->get("stopId","");
        $stoplines = $backService->stopLines($text);
        $response = new JsonResponse();
        /** @var RemoteStopLines $stoplines */

        $response->setData(
            $stoplines->toArray()
        );

        return $response;
    }

    /**
     * @Route("/getstoptimetable", name="referentiel_getstoptimetable", options={"expose"=true})
     */
    public function getStopTimetable(Request $request,BackService $backService,ReferentielService $referentielService){
        $stopId = $request->query->get("stopId","");
        $lineId = $request->query->get("lineId","");
        $direction = $request->query->get("direction","");
        $date = $request->query->get("date","");
        $stoptimetable = $backService->stopTimetable($stopId, $lineId, $direction, $date);

        $response = new JsonResponse();


        /** @var RemoteStopLineTimeTable $linetimetable */
        
        $response->setData(
            $stoptimetable->toArray()
        );

        return $response;
    }

    /**
     * @Route("/getlinetimetable", name="referentiel_getlinetimetable", options={"expose"=true})
     */
    public function getLineTimetable(Request $request,BackService $backService,ReferentielService $referentielService){
        $lineId = $request->query->get("lineId","");
        $direction = $request->query->get("direction","");
        $linetimetable = $backService->lineTimeTable($lineId, $direction);
        $response = new JsonResponse();
        /** @var RemoteStopLineTimeTable $linetimetable */
        $response->setData(
            $linetimetable->toArray()
        );

        return $response;
        
    }

    /**
     * @Route("/getitineraire", name="referentiel_getitineraire", options={"expose"=true})
     */
    public function getItineraire(Request $request,BackService $backService,ReferentielService $referentielService){
        $response = new JsonResponse();
        $from = $request->query->get("from","");
        $to = $request->query->get("to","");
        $datetime = $request->query->get("datetime","");
        $dateTimeRepresent = $request->query->get("datetype","");
        $mode = $request->query->get("mode",["0"]);
        $extra = $request->query->get("extra","");

        $itineraire = $backService->getItineraire($from, $to, $datetime, $dateTimeRepresent, $mode, $extra);

        $allIti = [];

        foreach ($itineraire as $iti){
            $allIti[] = $iti->toArray();
        }
        /** @var RemoteStopLineTimeTable $linetimetable */
        $response->setData(
            $allIti
        );

        return $response;
    }

}