$( document ).ready(function() {
    var currentDate = moment().locale('fr').format('YYYY-MM-DD');
    var month =  getDate(currentDate)

    if($('#calendar').length > 0) {
        getEventsForMonth(allEvents, month)
    }

    $('#previous').on('click', function(e){
        var tmp = currentDate.split("-");
        if(tmp[1] == '01'){
            tmp[1] = '12'
            tmp[0] = parseInt(tmp[0])-1
        }else{
            tmp[1] = parseInt(tmp[1])-1
        }

        if(tmp[1] < 10 && tmp[1] !== "01"){
            tmp[1] = ('0' + tmp[1] )
        }

        tmp[2] = 15;
        var newDate = tmp.join('-')
        month = getDate(newDate)
        currentDate = newDate

        getEventsForMonth(allEvents, month)
    })

    $("#next").on("click", function(e){
        var tmp = currentDate.split("-");

        if(tmp[1] == '12'){
            tmp[1] = '01'
            tmp[0] = parseInt(tmp[0])+1
        }else{
            tmp[1] = parseInt(tmp[1])+1
        }

        if(tmp[1] < 10 && tmp[1] !== "01"){
            tmp[1] = ('0' + tmp[1] )
        }

        tmp[2] = 15
        var newDate = tmp.join('-')
        month = getDate(newDate)
        currentDate = newDate

        getEventsForMonth(allEvents,month)
    })

    function getDate(date){
        $('#month').html("");
        $('#month').append(moment(date).locale('fr').format('MMMM YYYY'));

        var month = {
            start:parseInt(moment(date).startOf('month').format('X')),
            end:parseInt(moment(date).endOf('month').format('X'))
        }

        return month
    }

    function getEventsForMonth(events, monthConcerned){
        $('.calendarbody').html("")
        eventsInThisMonth = []

        for(var i = 0; i<events.length; i++){

            if(events[i].start > monthConcerned.start && events[i].start < monthConcerned.end){
                eventsInThisMonth.push(events[i])
            }
        }


        if(eventsInThisMonth.length == 0){
            $('.calendarbody').append(
                '<div class="alert alert-info">'+
                '<p> Aucun événement </p>'+
                '</div>'
            )
        }
        for(var j = 0; j<eventsInThisMonth.length; j++){
            var dateMomentStart = moment(eventsInThisMonth[j].start, "X").locale('fr')
            var dateMomentEnd = moment(eventsInThisMonth[j].end, "X").locale('fr')
            var dateDeb = moment(eventsInThisMonth[j].start, "X").locale('fr').format('DD MMM HH:mm')
            var dateFin = moment(eventsInThisMonth[j].end, "X").locale('fr').format('DD MMM HH:mm')
            var dateEve = "";
            if(dateMomentStart.format('DD MMM') == dateMomentEnd.format('DD MMM') && dateMomentStart.format('HH:mm') == "00:00" && dateMomentEnd.format('HH:mm') == "23:59"){
                dateEve = "Le "+dateMomentStart.format('DD MMMM')
            } else if(dateMomentStart.format('HH:mm') == "00:00" && dateMomentEnd.format('HH:mm') == "23:59"){
                dateEve = "Du "+dateMomentStart.format('DD MMMM')+" au "+dateMomentEnd.format('DD MMMM')
            } else if (dateMomentStart.format('DD MMM') == dateMomentEnd.format('DD MMM')){
                dateEve = "Le "+dateMomentStart.format('DD MMMM HH:mm')+" - "+dateMomentEnd.format('HH:mm')
            } else {
                dateEve = "Du "+dateMomentStart.format('DD MMMM HH:mm')+" au "+dateMomentEnd.format('DD MMMM HH:mm')
            }
            var title = eventsInThisMonth[j].title
            var content = eventsInThisMonth[j].content
            var id = eventsInThisMonth[j].id
            var typeActu = eventsInThisMonth[j].type_actu
            var image = eventsInThisMonth[j].image
            var link = eventsInThisMonth[j].link
            var style = ""
            var titleClass = ""
            if(image != ""){
                var urlimg = "/photos/actus/"+image+""
                style = "style = 'background-image : url(/photos/actus/"+image+")'"
                var titleClass = "title"
            } else {
                style = "style = 'background-image : url(/photos/actus/agenda-default.jpg)'"
                var titleClass = "title"
            }
            var card = '<div class="col-sm-6 well actu_'+typeActu+'">'+
                '<a class="linkActu" href="'+link+'" target="_blank">'+
                '<div class="event" data-id="'+id+'">'+
                '<div class="titlebkg" '+style+'><h3 class="'+titleClass+'">'+title+'</h3></div>'+
                '<div class="date-agenda '+typeActu+'" ><span class="icon-calendar"></span> '+dateEve+'</div>'+
                '<p class="accroche">'+content+'</p>'+
                '</div></div></a>'+
                '</div>'
            if(j == 0)
                $('.calendarbody').append('<div class="row">'+ card)
            else if(j%2 > 0)
                $('.calendarbody .row:last').append(card+'</div>')
            else if(j%2 == 0)
                $('.calendarbody').append('<div class="row">'+card)

        }
        $('.calendarbody').append('</div>');
    }
});
