<?php
/**
 * Created by PhpStorm.
 * User: damien
 * Date: 10/03/2018
 * Time: 19:46
 */

namespace Actigraph\ActipageBaseBundle\Services;


use Actigraph\ActipageBaseBundle\Services\IconCaptchaSession;
use Symfony\Component\HttpFoundation\RequestStack;

class CaptchaService
{
    private $requestStack;
    private $captcha;

    public function __construct($params, RequestStack $requestStack,ContentSecurityPolicyNonceService $contentSecurityPolicyNonceService) {
        $this->requestStack = $requestStack;
        if(!isset($params["captcha"]) || $params["captcha"]["type"] == "none"){
            $this->captcha = new CaptchaNone($this->requestStack->getSession(),$contentSecurityPolicyNonceService,array());
        }else{
            $config = $params["captcha"]["config"];
            if($params["captcha"]["type"] == "googlerecaptcha"){
                $this->captcha = new CaptchaGoogleRecaptcha($this->requestStack->getSession(),$contentSecurityPolicyNonceService,$config);
            } elseif ($params["captcha"]["type"] == "iconCaptcha"){
                $this->captcha = new CaptchaIconCaptcha($this->requestStack->getSession(),$contentSecurityPolicyNonceService);
            } elseif ($params["captcha"]["type"] == "hcaptcha"){
                $this->captcha = new CaptchaHcaptchaService($this->requestStack->getSession(),$contentSecurityPolicyNonceService,$config);
            } elseif ($params["captcha"]["type"] == "prosopo"){
                $this->captcha = new CaptchaProsopoService($this->requestStack->getSession(),$contentSecurityPolicyNonceService,$config);
            }
        }
    }

    public function getHtmlCaptcha(){
        return $this->captcha->getHtmlCaptcha();
    }

    public function isCaptchaValid($postData){
        return $this->captcha->isCaptchaValid($postData);
    }

    public function removeCaptchaParamFromPostData($posData){
        return $this->captcha->removeCaptchaParamFromPostData($posData);
    }
}
