<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 17/09/2018
 * Time: 14:33
 */

namespace Actigraph\ActipageBaseBundle\Services;

use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

class AddressAutocompleteService
{
    /** @var AdressAutocompleteInterface $autocomplete */
    private $autocomplete;

    public function __construct($params, RequestStack $requestStack,ContentSecurityPolicyNonceService $contentSecurityPolicyNonceService) {
        if(isset($params["autocompleteApi"])){
            if($params["autocompleteApi"]["type"] == "googleplace"){
                $config = $params["autocompleteApi"]["config"];
                $this->autocomplete = new GooglePlacesService($requestStack->getSession(), $contentSecurityPolicyNonceService, $config);
            }
        }
    }

    public function getHtmlAutocomplete(){
        if($this->autocomplete != null)
        return $this->autocomplete->getAutocompleteHtml();
    }

}