<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * TypeActu
 */
#[ORM\Table(name: 'type_actu')]
#[ORM\Entity(repositoryClass: \Actigraph\ActipageBaseBundle\Entity\TypeActuRepository::class)]
class TypeActu
{
    /**
     * @var integer
     */
    #[ORM\Column(name: 'id_type_actu', type: 'integer', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $idTypeActu;


    #[ORM\OneToMany(targetEntity: \Actus::class, mappedBy: 'typeActu')]
    private $actus;

    public function __construct()
    {
        $this->actus = new ArrayCollection();
    }

    /**
     * @var string
     */
    #[ORM\Column(name: 'nom_type_actu', type: 'string', length: 255, nullable: false)]
    private $nomTypeActu;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'ordre', type: 'integer', nullable: false)]
    private $ordre;

    /**
     * @return int
     */
    public function getIdTypeActu()
    {
        return $this->idTypeActu;
    }

    /**
     * @param int $idTypeActu
     */
    public function setIdTypeActu($idTypeActu)
    {
        $this->idTypeActu = $idTypeActu;
    }

    /**
     * @return string
     */
    public function getNomTypeActu()
    {
        return $this->nomTypeActu;
    }

    /**
     * @param string $nomTypeActu
     */
    public function setNomTypeActu($nomTypeActu)
    {
        $this->nomTypeActu = $nomTypeActu;
    }

    /**
     * @return int
     */
    public function getOrdre()
    {
        return $this->ordre;
    }

    /**
     * @param int $ordre
     */
    public function setOrdre($ordre)
    {
        $this->ordre = $ordre;
    }

    public function getStyle(){
        return array("classIcn"=>"success");
    }

    public function isActuStyle(){
        if($this->isInfoTrafficStyle() == false && $this->isAlerteStyle() == false)
            return true;
        return false;
    }

    public function isInfoTrafficStyle(){
        if($this->getNomTypeActu() == "Infos trafic")
            return true;
        else
            return false;
    }

    public function isAlerteStyle(){
        if($this->getNomTypeActu() == "Alerte" || $this->getNomTypeActu() == "Pré home Alerte" || $this->getNomTypeActu() == "Bulletin d'alerte")
            return true;
        else
            return false;
    }

    /**
     * @return mixed
     */
    public function getActus()
    {
        return $this->actus;
    }

    /**
     * @param mixed $actus
     */
    public function setActus($actus)
    {
        $this->actus = $actus;
    }

}
