<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Pages
 */
#[ORM\Table(name: 'pages')]
#[ORM\Entity]
class Pages
{
    /**
     * @var integer
     */
    #[ORM\Column(name: 'page_id', type: 'integer', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $pageId;

    /**
     * @var string
     */
    #[Assert\NotBlank(message: 'Vous devez définir un titre')]
    #[ORM\Column(name: 'page_titre', type: 'string', length: 255, nullable: true)]
    private $pageTitre;

    /**
     * @var string
     */
    #[Assert\NotBlank]
    #[ORM\Column(name: 'page_desc', type: 'string', length: 255, nullable: true)]
    private $pageDesc;

    /**
     * @var string
     */
    #[Assert\NotBlank]
    #[ORM\Column(name: 'page_mot', type: 'string', length: 255, nullable: true)]
    private $pageMot;

    /**
     * @var string
     */
    #[ORM\Column(name: 'page_lien', type: 'string', length: 255, nullable: false)]
    private $pageLien = '';

    /**
     * @var integer
     */
    #[ORM\Column(name: 'page_activ_lien', type: 'integer', nullable: false)]
    private $pageActivLien = '0';

    /**
     * @var integer
     */
    #[ORM\Column(name: 'page_externe', type: 'integer', nullable: false)]
    private $pageExterne = '0';

    /**
     * @var integer
     */
    #[ORM\Column(name: 'page_photo', type: 'integer', nullable: false)]
    private $pagePhoto = '0';

    /**
     * @var string
     */
    #[ORM\Column(name: 'page_text', type: 'text', nullable: true)]
    private $pageText;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'page_visu', type: 'integer', nullable: false)]
    private $pageVisu = '0';

    /**
     * @var integer
     */
    #[ORM\Column(name: 'page_pere', type: 'integer', nullable: false)]
    private $pagePere = '0';

    #[ORM\JoinColumn(name: 'page_pere', referencedColumnName: 'obj_id')]
    #[ORM\OneToOne(targetEntity: \Actigraph\ActipageBaseBundle\Entity\Objets::class, inversedBy: 'page', cascade: ['persist', 'detach'])]
    #[Assert\Valid]
    private $objet;


    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'page_deb', type: 'datetime', nullable: false)]
    private $pageDeb;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'page_fin', type: 'datetime', nullable: false)]
    private $pageFin;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'perenne', type: 'integer', nullable: false)]
    private $perenne = '1';

    /**
     * @var string
     */
    #[ORM\Column(name: 'page_text_preprod', type: 'text', nullable: false)]
    private $pageTextPreprod;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'modif_preprod', type: 'integer', nullable: false)]
    private $modifPreprod = '0';

    /**
     * @var boolean
     */
    #[ORM\Column(name: 'share', type: 'boolean', nullable: false)]
    private $share;

    /**
     * @var string
     */
    #[ORM\Column(name: 'page_params', type: 'string', length: 255, nullable: false)]
    private $pageParams;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'bloquage_referencement', type: 'integer', nullable: false)]
    private $bloquageReferencement = '0';

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'brouillon_date_debut', type: 'date', nullable: false)]
    private $brouillonDateDebut;

    /**
     * @return int
     */
    public function getBloquageReferencement()
    {
        return $this->bloquageReferencement;
    }

    /**
     * @param int $bloquageReferencement
     */
    public function setBloquageReferencement($bloquageReferencement)
    {
        $this->bloquageReferencement = $bloquageReferencement;
    }

    /**
     * @return \DateTime
     */
    public function getBrouillonDateDebut()
    {
        return $this->brouillonDateDebut;
    }

    /**
     * @param \DateTime $brouillonDateDebut
     */
    public function setBrouillonDateDebut($brouillonDateDebut)
    {
        $this->brouillonDateDebut = $brouillonDateDebut;
    }

    /**
     * @return int
     */
    public function getModifPreprod()
    {
        return $this->modifPreprod;
    }

    /**
     * @param int $modifPreprod
     */
    public function setModifPreprod($modifPreprod)
    {
        $this->modifPreprod = $modifPreprod;
    }

    /**
     * @return int
     */
    public function getPageActivLien()
    {
        return $this->pageActivLien;
    }

    /**
     * @param int $pageActivLien
     */
    public function setPageActivLien($pageActivLien)
    {
        $this->pageActivLien = $pageActivLien;
    }

    /**
     * @return \DateTime
     */
    public function getPageDeb()
    {
        return $this->pageDeb;
    }

    /**
     * @param \DateTime $pageDeb
     */
    public function setPageDeb($pageDeb)
    {
        $this->pageDeb = $pageDeb;
    }

    /**
     * @return string
     */
    public function getPageDesc()
    {
        return $this->pageDesc;
    }

    /**
     * @param string $pageDesc
     */
    public function setPageDesc($pageDesc)
    {
        $this->pageDesc = $pageDesc;
    }

    /**
     * @return int
     */
    public function getPageExterne()
    {
        return $this->pageExterne;
    }

    /**
     * @param int $pageExterne
     */
    public function setPageExterne($pageExterne)
    {
        $this->pageExterne = $pageExterne;
    }

    /**
     * @return \DateTime
     */
    public function getPageFin()
    {
        return $this->pageFin;
    }

    /**
     * @param \DateTime $pageFin
     */
    public function setPageFin($pageFin)
    {
        $this->pageFin = $pageFin;
    }

    /**
     * @return int
     */
    public function getPageId()
    {
        return $this->pageId;
    }

    /**
     * @param int $pageId
     */
    public function setPageId($pageId)
    {
        $this->pageId = $pageId;
    }

    /**
     * @return string
     */
    public function getPageLien()
    {
        return $this->pageLien;
    }

    /**
     * @param string $pageLien
     */
    public function setPageLien($pageLien)
    {
        $this->pageLien = $pageLien;
    }

    /**
     * @return string
     */
    public function getPageMot()
    {
        return $this->pageMot;
    }

    /**
     * @param string $pageMot
     */
    public function setPageMot($pageMot)
    {
        $this->pageMot = $pageMot;
    }

    /**
     * @return string
     */
    public function getPageParams()
    {
        return $this->pageParams;
    }

    /**
     * @param string $pageParams
     */
    public function setPageParams($pageParams)
    {
        $this->pageParams = $pageParams;
    }

    /**
     * @return int
     */
    public function getPagePere()
    {
        return $this->pagePere;
    }

    /**
     * @param int $pagePere
     */
    public function setPagePere($pagePere)
    {
        $this->pagePere = $pagePere;
    }

    /**
     * @return int
     */
    public function getPagePhoto()
    {
        return $this->pagePhoto;
    }

    /**
     * @param int $pagePhoto
     */
    public function setPagePhoto($pagePhoto)
    {
        $this->pagePhoto = $pagePhoto;
    }

    /**
     * @return string
     */
    public function getPageText()
    {
        return $this->pageText;
    }

    /**
     * @param string $pageText
     */
    public function setPageText($pageText)
    {
        $this->pageText = $pageText;
    }

    /**
     * @return string
     */
    public function getPageTextPreprod()
    {
        return $this->pageTextPreprod;
    }

    /**
     * @param string $pageTextPreprod
     */
    public function setPageTextPreprod($pageTextPreprod)
    {
        $this->pageTextPreprod = $pageTextPreprod;
    }

    /**
     * @return string
     */
    public function getPageTitre()
    {
        return $this->pageTitre;
    }

    /**
     * @param string $pageTitre
     */
    public function setPageTitre($pageTitre)
    {
        $this->pageTitre = $pageTitre;
    }

    /**
     * @return int
     */
    public function getPageVisu()
    {
        return $this->pageVisu;
    }

    /**
     * @param int $pageVisu
     */
    public function setPageVisu($pageVisu)
    {
        $this->pageVisu = $pageVisu;
    }

    /**
     * @return int
     */
    public function getPerenne()
    {
        return $this->perenne;
    }

    /**
     * @param int $perenne
     */
    public function setPerenne($perenne)
    {
        $this->perenne = $perenne;
    }

    /**
     * @return boolean
     */
    public function getShare()
    {
        return $this->share;
    }

    /**
     * @param boolean $share
     */
    public function setShare($share)
    {
        $this->share = $share;
    }

    /**
     * @return mixed
     */
    public function getObjet()
    {
        return $this->objet;
    }

    /**
     * @param mixed $objet
     */
    public function setObjet($objet)
    {
        $this->objet = $objet;
    }
}
