<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * NewsletterStatsClick
 */
#[ORM\Table(name: 'newsletter_stats_click')]
#[ORM\Entity]
class NewsletterStatsClick
{
    /**
     * @var integer
     */
    #[ORM\Column(name: 'id', type: 'bigint', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $id;

    /**
     * @var integer
     *
     */
    #[ORM\Column(name: 'idInscrit', type: 'bigint', nullable: false)]
    private $idinscrit;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'idNewsletter', type: 'bigint', nullable: false)]
    private $idnewsletter;

    #[ORM\JoinColumn(name: 'idNewsletterUrl', referencedColumnName: 'id')]
    #[ORM\ManyToOne(targetEntity: \Actigraph\ActipageBaseBundle\Entity\NewsletterUrl::class, inversedBy: 'statsclick')]
    private $url;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'idNewsletterUrl', type: 'bigint', nullable: false)]
    private $idnewsletterurl;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'dateClick', type: 'datetime', nullable: false)]
    private $dateClick;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getIdinscrit()
    {
        return $this->idinscrit;
    }

    /**
     * @param int $idinscrit
     */
    public function setIdinscrit($idinscrit)
    {
        $this->idinscrit = $idinscrit;
    }

    /**
     * @return int
     */
    public function getIdnewsletter()
    {
        return $this->idnewsletter;
    }

    /**
     * @param int $idnewsletter
     */
    public function setIdnewsletter($idnewsletter)
    {
        $this->idnewsletter = $idnewsletter;
    }

    /**
     * @return int
     */
    public function getIdnewsletterurl()
    {
        return $this->idnewsletterurl;
    }

    /**
     * @param int $idnewsletterurl
     */
    public function setIdnewsletterurl($idnewsletterurl)
    {
        $this->idnewsletterurl = $idnewsletterurl;
    }

    /**
     * @return mixed
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param mixed $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return \DateTime
     */
    public function getDateClick()
    {
        return $this->dateClick;
    }

    /**
     * @param \DateTime $dateClick
     */
    public function setDateClick(\DateTime $dateClick): void
    {
        $this->dateClick = $dateClick;
    }


}
