<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * NewsletterStats
 */
#[ORM\Table(name: 'newsletter_stats')]
#[ORM\Entity]
class NewsletterStats
{
    /**
     * @var integer
     */
    #[ORM\Column(name: 'id_newsletter', type: 'integer', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $idNewsletter;

    #[ORM\JoinColumn(name: 'id_newsletter', referencedColumnName: 'newsletter_id')]
    #[ORM\OneToOne(targetEntity: \Actigraph\ActipageBaseBundle\Entity\Newsletters::class, inversedBy: 'stat')]
    private $newsletter;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'nb_envoyes', type: 'integer', nullable: false)]
    private $nbEnvoyes;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'nb_ouverts', type: 'integer', nullable: false)]
    private $nbOuverts;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'nb_ouverts_en_ligne', type: 'integer', nullable: false)]
    private $nbOuvertsEnLigne;

    /**
     * @return int
     */
    public function getIdNewsletter()
    {
        return $this->idNewsletter;
    }

    /**
     * @param int $idNewsletter
     */
    public function setIdNewsletter($idNewsletter)
    {
        $this->idNewsletter = $idNewsletter;
    }

    /**
     * @return int
     */
    public function getNbEnvoyes()
    {
        return $this->nbEnvoyes;
    }

    /**
     * @param int $nbEnvoyes
     */
    public function setNbEnvoyes($nbEnvoyes)
    {
        $this->nbEnvoyes = $nbEnvoyes;
    }

    /**
     * @return int
     */
    public function getNbOuverts()
    {
        return $this->nbOuverts;
    }

    /**
     * @param int $nbOuverts
     */
    public function setNbOuverts($nbOuverts)
    {
        $this->nbOuverts = $nbOuverts;
    }

    /**
     * @return int
     */
    public function getNbOuvertsEnLigne()
    {
        return $this->nbOuvertsEnLigne;
    }

    /**
     * @param int $nbOuvertsEnLigne
     */
    public function setNbOuvertsEnLigne($nbOuvertsEnLigne)
    {
        $this->nbOuvertsEnLigne = $nbOuvertsEnLigne;
    }

    /**
     * @return mixed
     */
    public function getNewsletter()
    {
        return $this->newsletter;
    }

    /**
     * @param mixed $newsletter
     */
    public function setNewsletter($newsletter)
    {
        $this->newsletter = $newsletter;
    }


}
