<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * NewsletterParam
 */
#[ORM\Table(name: 'newsletter_param')]
#[ORM\Entity]
class NewsletterParam
{
    /**
     * @var boolean
     */
    #[ORM\Column(name: 'envoi_vers_mail_invalide', type: 'boolean', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $envoiVersMailInvalide = '0';

    /**
     * @var string
     */
    #[ORM\Column(name: 'from', type: 'text', nullable: false)]
    private $from;

    /**
     * @var string
     */
    #[ORM\Column(name: 'from_name', type: 'text', nullable: false)]
    private $fromName;

    /**
     * @var string
     */
    #[ORM\Column(name: 'desincription_url', type: 'text', nullable: false)]
    private $desincriptionUrl;

    /**
     * @var string
     */
    #[ORM\Column(name: 'consultation_enligne_url', type: 'text', nullable: false)]
    private $consultationEnligneUrl;

    /**
     * @var string
     */
    #[ORM\Column(name: 'email_notification_desinscription', type: 'text', nullable: false)]
    private $emailNotificationDesinscription;

    /**
     * @return string
     */
    public function getConsultationEnligneUrl()
    {
        return $this->consultationEnligneUrl;
    }

    /**
     * @param string $consultationEnligneUrl
     */
    public function setConsultationEnligneUrl($consultationEnligneUrl)
    {
        $this->consultationEnligneUrl = $consultationEnligneUrl;
    }

    /**
     * @return string
     */
    public function getDesincriptionUrl()
    {
        return $this->desincriptionUrl;
    }

    /**
     * @param string $desincriptionUrl
     */
    public function setDesincriptionUrl($desincriptionUrl)
    {
        $this->desincriptionUrl = $desincriptionUrl;
    }

    /**
     * @return boolean
     */
    public function getEnvoiVersMailInvalide()
    {
        return $this->envoiVersMailInvalide;
    }

    /**
     * @param boolean $envoiVersMailInvalide
     */
    public function setEnvoiVersMailInvalide($envoiVersMailInvalide)
    {
        $this->envoiVersMailInvalide = $envoiVersMailInvalide;
    }

    /**
     * @return string
     */
    public function getFrom()
    {
        return $this->from;
    }

    /**
     * @param string $from
     */
    public function setFrom($from)
    {
        $this->from = $from;
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return $this->fromName;
    }

    /**
     * @param string $fromName
     */
    public function setFromName($fromName)
    {
        $this->fromName = $fromName;
    }

    /**
     * @return string
     */
    public function getEmailNotificationDesinscription(): string
    {
        return $this->emailNotificationDesinscription;
    }

    /**
     * @param string $emailNotificationDesinscription
     */
    public function setEmailNotificationDesinscription(string $emailNotificationDesinscription): void
    {
        $this->emailNotificationDesinscription = $emailNotificationDesinscription;
    }


}
