<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * NewsletterInscritsHisto
 */
#[ORM\Table(name: 'newsletter_inscrits_histo')]
#[ORM\Entity]
class NewsletterInscritsHisto
{
    /**
     * @var integer
     */
    #[ORM\Column(name: 'id_inscrit', type: 'integer', nullable: false)]
    #[ORM\Id]
    private $idInscrit;

    /**
     * @var string
     */
    #[ORM\Column(name: 'nom', type: 'string', length: 255, nullable: false)]
    private $nom;

    /**
     * @var string
     */
    #[ORM\Column(name: 'prenom', type: 'string', length: 255, nullable: false)]
    private $prenom;

    /**
     * @var string
     */
    #[ORM\Column(name: 'mail', type: 'string', length: 255, nullable: false)]
    private $mail;

    /**
     * @var string
     */
    #[ORM\Column(name: 'bdate', type: 'string', length: 255, nullable: false)]
    private $bdate;

    /**
     * @var boolean
     */
    #[ORM\Column(name: 'inscrit', type: 'boolean', nullable: false)]
    private $inscrit;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'date_inscription', type: 'bigint', nullable: false)]
    private $dateInscription;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'date_desinscription', type: 'bigint', nullable: false)]
    private $dateDesinscription;

    /**
     * @return string
     */
    public function getBdate()
    {
        return $this->bdate;
    }

    /**
     * @param string $bdate
     */
    public function setBdate($bdate)
    {
        $this->bdate = $bdate;
    }

    /**
     * @return int
     */
    public function getDateDesinscription()
    {
        return $this->dateDesinscription;
    }

    /**
     * @param int $dateDesinscription
     */
    public function setDateDesinscription($dateDesinscription)
    {
        $this->dateDesinscription = $dateDesinscription;
    }

    /**
     * @return int
     */
    public function getDateInscription()
    {
        return $this->dateInscription;
    }

    /**
     * @param int $dateInscription
     */
    public function setDateInscription($dateInscription)
    {
        $this->dateInscription = $dateInscription;
    }

    /**
     * @return int
     */
    public function getIdInscrit()
    {
        return $this->idInscrit;
    }

    /**
     * @param int $idInscrit
     */
    public function setIdInscrit($idInscrit)
    {
        $this->idInscrit = $idInscrit;
    }

    /**
     * @return boolean
     */
    public function getInscrit()
    {
        return $this->inscrit;
    }

    /**
     * @param boolean $inscrit
     */
    public function setInscrit($inscrit)
    {
        $this->inscrit = $inscrit;
    }

    /**
     * @return string
     */
    public function getMail()
    {
        return $this->mail;
    }

    /**
     * @param string $mail
     */
    public function setMail($mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param string $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return string
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * @param string $prenom
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;
    }


}
