<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * NewsletterGroupes
 */
#[ORM\Table(name: 'newsletter_groupes')]
#[ORM\Entity(repositoryClass: \Actigraph\ActipageBaseBundle\Entity\NewsletterGroupesRepository::class)]
class NewsletterGroupes
{
    /**
     * @var integer
     */
    #[ORM\Column(name: 'groupe_id', type: 'bigint', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $groupeId;

    /**
     * @var string
     */
    #[ORM\Column(name: 'groupe_nom', type: 'string', length: 255, nullable: false)]
    private $groupeNom;

    /**
     * @var string
     */
    #[ORM\Column(name: 'groupe_description', type: 'text', nullable: false)]
    private $groupeDescription;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'groupe_type', type: 'bigint', nullable: false)]
    private $groupeType;

    #[ORM\JoinColumn(name: 'groupe_type', referencedColumnName: 'id_type')]
    #[ORM\ManyToOne(targetEntity: \Actigraph\ActipageBaseBundle\Entity\NewsletterGroupesType::class, inversedBy: 'groupes')]
    private $groupeTypeObj;


    #[ORM\JoinTable(name: 'newsletter_groupes_list')]
    #[ORM\JoinColumn(name: 'groupe_id', referencedColumnName: 'groupe_id')]
    #[ORM\InverseJoinColumn(name: 'inscrit_id', referencedColumnName: 'id_inscrit')]
    #[ORM\ManyToMany(targetEntity: \Actigraph\ActipageBaseBundle\Entity\Inscrit::class, inversedBy: 'groupeObj')]
    private $inscrits;

    /**
     * @var boolean
     */
    #[ORM\Column(name: 'visible_front', type: 'boolean', nullable: false)]
    private $visibleFront;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'sort_order', type: 'integer', nullable: false)]
    private $sortOrder;

    public function __construct()
    {
        $this->inscrits = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getGroupeDescription()
    {
        return $this->groupeDescription;
    }

    /**
     * @param string $groupeDescription
     */
    public function setGroupeDescription($groupeDescription)
    {
        $this->groupeDescription = $groupeDescription;
    }

    /**
     * @return int
     */
    public function getGroupeId()
    {
        return $this->groupeId;
    }

    /**
     * @param int $groupeId
     */
    public function setGroupeId($groupeId)
    {
        $this->groupeId = $groupeId;
    }

    /**
     * @return string
     */
    public function getGroupeNom()
    {
        return $this->groupeNom;
    }

    /**
     * @param string $groupeNom
     */
    public function setGroupeNom($groupeNom)
    {
        $this->groupeNom = $groupeNom;
    }

    /**
     * @return int
     */
    public function getGroupeType()
    {
        return $this->groupeType;
    }

    /**
     * @param int $groupeType
     */
    public function setGroupeType($groupeType)
    {
        $this->groupeType = $groupeType;
    }

    /**
     * @return int
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }

    /**
     * @param int $sortOrder
     */
    public function setSortOrder($sortOrder)
    {
        $this->sortOrder = $sortOrder;
    }

    /**
     * @return boolean
     */
    public function getVisibleFront()
    {
        return $this->visibleFront;
    }

    /**
     * @param boolean $visibleFront
     */
    public function setVisibleFront($visibleFront)
    {
        $this->visibleFront = $visibleFront;
    }

    /**
     * @return mixed
     */
    public function getGroupeTypeObj()
    {
        return $this->groupeTypeObj;
    }

    /**
     * @param mixed $groupeTypeObj
     */
    public function setGroupeTypeObj($groupeTypeObj)
    {
        $this->groupeTypeObj = $groupeTypeObj;
    }

    /**
     * @return mixed
     */
    public function getInscrits()
    {
        return $this->inscrits;
    }

    /**
     * @param mixed $inscrits
     */
    public function setInscrits($inscrits)
    {
        $this->inscrits = $inscrits;
    }


}
