<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ModuleListe
 */
#[ORM\Table(name: 'module_liste')]
#[ORM\Entity]
class ModuleListe
{

    /**
     * @var integer
     */
    #[ORM\Column(name: 'id_module', type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private $idModule;

    /**
     * @var string
     */
    #[ORM\Column(name: 'nom_module', type: 'string', length: 100)]
    private $nomModule;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'classModule', type: 'integer')]
    private $classModule;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'classModule_front', type: 'integer')]
    private $classModuleFront;


    /**
     * @var string
     */
    #[ORM\Column(name: 'lien_module', type: 'string', length: 150)]
    private $lienModule;

    /**
     * @var string
     */
    #[ORM\Column(name: 'front_moduleClass', type: 'string', length: 150)]
    private $frontModuleClass;

    /**
     * @var string
     */
    #[ORM\Column(name: 'nom_admin', type: 'string', length: 255)]
    private $nomAdmin;

    /**
     * @var string
     */
    #[ORM\Column(name: 'lien_admin', type: 'string', length: 255)]
    private $lienAdmin;

    /**
     * @var boolean
     */
    #[ORM\Column(name: 'site_mobile', type: 'boolean')]
    private $siteMobile;

    /**
     * @var string
     */
    #[ORM\Column(name: 'param_module', type: 'string', length: 255)]
    private $paramModule;



    /**
     * Get idModule
     *
     * @return integer
     */
    public function getIdModule()
    {
        return $this->idModule;
    }

    /**
     * Set nomModule
     *
     * @param string $nomModule
     * @return ModuleListe
     */
    public function setNomModule($nomModule)
    {
        $this->nomModule = $nomModule;

        return $this;
    }

    /**
     * Get nomModule
     *
     * @return string
     */
    public function getNomModule()
    {
        return $this->nomModule;
    }

    /**
     * Set classModule
     *
     * @param integer $classModule
     * @return ModuleListe
     */
    public function setClassModule($classModule)
    {
        $this->classModule = $classModule;

        return $this;
    }

    /**
     * Get classModule
     *
     * @return integer
     */
    public function getClassModule()
    {
        return $this->classModule;
    }

    /**
     * @return int
     */
    public function getClassModuleFront()
    {
        return $this->classModuleFront;
    }

    /**
     * @param int $classModuleFront
     */
    public function setClassModuleFront($classModuleFront)
    {
        $this->classModuleFront = $classModuleFront;
    }


    /**
     * Set lienModule
     *
     * @param string $lienModule
     * @return ModuleListe
     */
    public function setLienModule($lienModule)
    {
        $this->lienModule = $lienModule;

        return $this;
    }

    /**
     * Get lienModule
     *
     * @return string
     */
    public function getLienModule()
    {
        return $this->lienModule;
    }

    /**
     * Set nomAdmin
     *
     * @param string $nomAdmin
     * @return ModuleListe
     */
    public function setNomAdmin($nomAdmin)
    {
        $this->nomAdmin = $nomAdmin;

        return $this;
    }

    /**
     * Get nomAdmin
     *
     * @return string
     */
    public function getNomAdmin()
    {
        return $this->nomAdmin;
    }

    /**
     * Set lienAdmin
     *
     * @param string $lienAdmin
     * @return ModuleListe
     */
    public function setLienAdmin($lienAdmin)
    {
        $this->lienAdmin = $lienAdmin;

        return $this;
    }

    /**
     * Get lienAdmin
     *
     * @return string
     */
    public function getLienAdmin()
    {
        return $this->lienAdmin;
    }

    /**
     * Set siteMobile
     *
     * @param boolean $siteMobile
     * @return ModuleListe
     */
    public function setSiteMobile($siteMobile)
    {
        $this->siteMobile = $siteMobile;

        return $this;
    }

    /**
     * Get siteMobile
     *
     * @return boolean
     */
    public function getSiteMobile()
    {
        return $this->siteMobile;
    }

    /**
     * @return string
     */
    public function getFrontModuleClass()
    {
        return $this->frontModuleClass;
    }

    /**
     * @param string $frontModuleClass
     */
    public function setFrontModuleClass($frontModuleClass)
    {
        $this->frontModuleClass = $frontModuleClass;
    }

    /**
     * @return string
     */
    public function getParamModule()
    {
        return $this->paramModule;
    }

    /**
     * @param string $paramModule
     */
    public function setParamModule($paramModule)
    {
        $this->paramModule = $paramModule;
    }
}
