<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * Inscrit
 */
#[ORM\Table(name: 'inscrit')]
#[ORM\Entity]
#[UniqueEntity('mail', message: 'Cette adresse email est déjà enregistrée.')]
class Inscrit
{
    /**
     * @var integer
     */
    #[ORM\Column(name: 'id_inscrit', type: 'integer', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $idInscrit;

    /**
     * @var string
     */
    #[ORM\Column(name: 'nom', type: 'text', nullable: false)]
    private $nom;

    /**
     * @var string
     */
    #[ORM\Column(name: 'prenom', type: 'text', nullable: false)]
    private $prenom;

    /**
     * @var string
     */
    #[Assert\Email(message: "L'email '{{ value }}' n'est pas une email valide")]
    #[Assert\NotBlank(message: 'Vous devez saisir une email')]
    #[ORM\Column(name: 'mail', type: 'text', nullable: false, unique: true)]
    private $mail;

    /**
     * @var string
     */
    #[ORM\Column(name: 'bdate', type: 'text', nullable: false)]
    private $bdate;

    /**
     * @var string
     */
    #[ORM\Column(name: 'groupe', type: 'text', nullable: false)]
    private $groupe;

    #[ORM\ManyToMany(targetEntity: \Actigraph\ActipageBaseBundle\Entity\NewsletterGroupes::class, mappedBy: 'inscrits', cascade: ['persist'])]
    private $groupeObj;
    /**
     * @var string
     */
    #[ORM\Column(name: 'societe', type: 'text', nullable: false)]
    private $societe;

    /**
     * @var string
     */
    #[ORM\Column(name: 'fonction', type: 'text', nullable: false)]
    private $fonction;

    /**
     * @var string
     */
    #[ORM\Column(name: 'urlSite', type: 'text', nullable: false)]
    private $urlsite;

    /**
     * @var string
     */
    #[ORM\Column(name: 'dateInscr', type: 'text', nullable: false)]
    private $dateinscr;

    /**
     * @var string
     */
    #[ORM\Column(name: 'dateModif', type: 'text', nullable: false)]
    private $datemodif;

    /**
     * @var string
     */
    #[ORM\Column(name: 'adresse', type: 'text', nullable: false)]
    private $adresse;

    /**
     * @var string
     */
    #[ORM\Column(name: 'cp', type: 'string', length: 255, nullable: false)]
    private $cp;

    /**
     * @var string
     */
    #[ORM\Column(name: 'ville', type: 'text', nullable: false)]
    private $ville;

    /**
     * @var string
     */
    #[ORM\Column(name: 'telFixe', type: 'string', length: 255, nullable: false)]
    private $telfixe;

    /**
     * @var string
     */
    #[ORM\Column(name: 'telMobile', type: 'string', length: 255, nullable: false)]
    private $telmobile;

    /**
     * @var string
     */
    #[ORM\Column(name: 'motsCles', type: 'text', nullable: false)]
    private $motscles;

    /**
     * @var string
     */
    #[ORM\Column(name: 'commentaire', type: 'text', nullable: false)]
    private $commentaire;

    /**
     * @var integer
     */
    #[ORM\Column(name: 'errorId', type: 'integer', nullable: false)]
    private $errorid;

    /**
     * @var boolean
     */
    #[ORM\Column(name: 'email_verif', type: 'boolean', nullable: false)]
    private $emailVerif = '0';

    /**
     * @var integer
     */
    #[ORM\Column(name: 'rgpd_preuve', type: 'string', length: 1, nullable: true)]
    private $rgpd_preuve = '';

    /**
     * @var integer
     */
    #[ORM\Column(name: 'rgpd_confirmation', type: 'text', nullable: true)]
    private $rgpd_confirmation = '';


    public function __construct() {
        $this->groupeObj = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getAdresse()
    {
        return $this->adresse;
    }

    /**
     * @param string $adresse
     */
    public function setAdresse($adresse)
    {
        $this->adresse = $adresse;
    }

    /**
     * @return string
     */
    public function getBdate()
    {
        return $this->bdate;
    }

    /**
     * @param string $bdate
     */
    public function setBdate($bdate)
    {
        $this->bdate = $bdate;
    }

    /**
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * @param string $commentaire
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;
    }

    /**
     * @return string
     */
    public function getCp()
    {
        return $this->cp;
    }

    /**
     * @param string $cp
     */
    public function setCp($cp)
    {
        $this->cp = $cp;
    }

    /**
     * @return string
     */
    public function getDateinscr()
    {
        return $this->dateinscr;
    }

    /**
     * @param string $dateinscr
     */
    public function setDateinscr($dateinscr)
    {
        $this->dateinscr = $dateinscr;
    }

    /**
     * @return string
     */
    public function getDatemodif()
    {
        return $this->datemodif;
    }

    /**
     * @param string $datemodif
     */
    public function setDatemodif($datemodif)
    {
        $this->datemodif = $datemodif;
    }

    /**
     * @return boolean
     */
    public function getEmailVerif()
    {
        return $this->emailVerif;
    }

    /**
     * @param boolean $emailVerif
     */
    public function setEmailVerif($emailVerif)
    {
        $this->emailVerif = $emailVerif;
    }

    /**
     * @return int
     */
    public function getErrorid()
    {
        return $this->errorid;
    }

    /**
     * @param int $errorid
     */
    public function setErrorid($errorid)
    {
        $this->errorid = $errorid;
    }

    /**
     * @return string
     */
    public function getFonction()
    {
        return $this->fonction;
    }

    /**
     * @param string $fonction
     */
    public function setFonction($fonction)
    {
        $this->fonction = $fonction;
    }

    /**
     * @return string
     */
    public function getGroupe()
    {
        return $this->groupe;
    }

    /**
     * @param string $groupe
     */
    public function setGroupe($groupe)
    {
        $this->groupe = $groupe;
    }

    /**
     * @return int
     */
    public function getIdInscrit()
    {
        return $this->idInscrit;
    }

    /**
     * @param int $idInscrit
     */
    public function setIdInscrit($idInscrit)
    {
        $this->idInscrit = $idInscrit;
    }

    /**
     * @return string
     */
    public function getMail()
    {
        return $this->mail;
    }

    /**
     * @param string $mail
     */
    public function setMail($mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return string
     */
    public function getMotscles()
    {
        return $this->motscles;
    }

    /**
     * @param string $motscles
     */
    public function setMotscles($motscles)
    {
        $this->motscles = $motscles;
    }

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param string $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return string
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * @param string $prenom
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;
    }

    /**
     * @return string
     */
    public function getSociete()
    {
        return $this->societe;
    }

    /**
     * @param string $societe
     */
    public function setSociete($societe)
    {
        $this->societe = $societe;
    }

    /**
     * @return string
     */
    public function getTelfixe()
    {
        return $this->telfixe;
    }

    /**
     * @param string $telfixe
     */
    public function setTelfixe($telfixe)
    {
        $this->telfixe = $telfixe;
    }

    /**
     * @return string
     */
    public function getTelmobile()
    {
        return $this->telmobile;
    }

    /**
     * @param string $telmobile
     */
    public function setTelmobile($telmobile)
    {
        $this->telmobile = $telmobile;
    }

    /**
     * @return string
     */
    public function getUrlsite()
    {
        return $this->urlsite;
    }

    /**
     * @param string $urlsite
     */
    public function setUrlsite($urlsite)
    {
        $this->urlsite = $urlsite;
    }

    /**
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * @param string $ville
     */
    public function setVille($ville)
    {
        $this->ville = $ville;
    }
    /*
     * Permet de savoir si l'email est valable pour l'envoie d'une newsletter
     */
    public function isValidForNewsletter(){
        if($this->getEmailVerif() == 1 || $this->getEmailVerif() == 10)
            return true;
        return false;
    }

    /**
     * @return mixed
     */
    public function getGroupeObj()
    {
        return $this->groupeObj;
    }

    /**
     * @param mixed $groupeObj
     */
    public function setGroupeObj($groupeObj)
    {
        $this->groupeObj = $groupeObj;
    }

    public function addGroupeObj($groupeObj)
    {
        $this->groupeObj[] = $groupeObj;
        $inscrits = $groupeObj->getInscrits();
        $inscrits[] = $this;
        $groupeObj->setInscrits($inscrits);

        return $this;
    }

    public function removeGroupeObj($groupeObj)
    {
        $this->groupeObj->removeElement($groupeObj);

        $inscrits = $groupeObj->getInscrits();
        $inscrits->removeElement($this);
        $groupeObj->setInscrits($inscrits);
        return $this;
    }

    /**
     * @return int
     */
    public function getRgpdPreuve()
    {
        return $this->rgpd_preuve;
    }

    /**
     * @param int $rgpd_preuve
     */
    public function setRgpdPreuve($rgpd_preuve)
    {
        $this->rgpd_preuve = $rgpd_preuve;
    }

    /**
     * @return int
     */
    public function getRgpdConfirmation()
    {
        return $this->rgpd_confirmation;
    }

    /**
     * @param int $rgpd_confirmation
     */
    public function setRgpdConfirmation($rgpd_confirmation)
    {
        $this->rgpd_confirmation = $rgpd_confirmation;
    }
}
