<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;


/**
 * GraviteActu
 */
#[ORM\Table(name: 'gravite_actu')]
#[ORM\Entity]
class GraviteActu
{

    /**
     * @var integer
     */
    #[ORM\Column(name: 'id', type: 'integer', nullable: false)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private $id;

    #[ORM\OneToMany(targetEntity: \Actus::class, mappedBy: 'graviteActu')]
    private $actus;



    public function __construct()
    {
        $this->actus = new ArrayCollection();
    }

    /**
     * @var string
     */
    #[ORM\Column(name: 'nom', type: 'string', length: 255, nullable: false)]
    private $nom;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param string $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return mixed
     */
    public function getActus()
    {
        return $this->actus;
    }

    /**
     * @param mixed $actus
     */
    public function setActus($actus)
    {
        $this->actus = $actus;
    }

}