<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
class FormuleItem
{
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    private $id;

    #[ORM\ManyToOne(targetEntity: \FormuleProfile::class, inversedBy: 'formuleItems')]
    private $profile;

    #[ORM\Column(type: 'boolean', nullable: false)]
    private $isOccasionnel;

    #[ORM\Column(type: 'boolean', nullable: false)]
    private $isRegulier;

    #[ORM\JoinTable(name: 'formule_relation')]
    #[ORM\ManyToMany(targetEntity: \Formule::class, mappedBy: 'items')]
    private $formules;

    #[ORM\Column(type: 'datetime', nullable: false)]
    private $createdAt;

    #[ORM\Column(type: 'datetime', nullable: true)]
    private $updatedAt;

    #[ORM\Column(type: 'datetime', nullable: true)]
    private $updatedBy;

    public function __construct(FormuleProfile $profile)
    {
        $this->setProfile($profile);
        $this->setCreatedAt(new \DateTime());
        $this->formules = new ArrayCollection();
        $this->setIsOccasionnel(false)
            ->setIsRegulier(false);
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId(?int $id)
    {
        $this->id = $id;

        return $this;
    }

    public function getIsOccasionnel()
    {
        return $this->isOccasionnel;
    }

    public function setIsOccasionnel($isOccasionnel): self
    {
        $this->isOccasionnel = $isOccasionnel;

        return $this;
    }

    public function getIsRegulier()
    {
        return $this->isRegulier;
    }

    public function setIsRegulier($isRegulier): self
    {
        $this->isRegulier = $isRegulier;

        return $this;
    }

    /**
     * @return Collection|Formule[]
     */
    public function getFormules(): Collection
    {
        return $this->formules;
    }

    public function addFormule(Formule $formule): self
    {
        if (!$this->formules->contains($formule)) {
            $this->formules[] = $formule;
        }
        return $this;
    }

    public function removeFormule(Formule $formule): self
    {
        $this->formules->removeElement($formule);

        return $this;
    }

    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    public function setCreatedAt($createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
    public function setUpdatedAt($updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getUpdatedBy()
    {
        return $this->updatedBy;
    }

    public function setUpdatedBy($updatedBy): self
    {
        $this->updatedBy = $updatedBy;

        return $this;
    }

    public function getProfile(): ?FormuleProfile
    {
        return $this->profile;
    }

    public function setProfile(FormuleProfile $profile)
    {
        $this->profile = $profile;

        return $this;
    }
}
