<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
class FormuleConfig
{
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    private $id;

    #[ORM\Column(type: 'string', nullable: false, length: 255)]
    private $label;

    #[ORM\Column(type: 'string', nullable: false, length: 255)]
    private $name;

    #[ORM\Column(type: 'string', nullable: false, length: 255)]
    private $type;

    #[ORM\Column(type: 'string', nullable: true, length: 255)]
    private $linkedWith;

    #[ORM\Column(type: 'json', nullable: false)]
    private $values;

    #[ORM\Column(type: 'json', nullable: false)]
    private $options;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function setLabel($label): self
    {
        $this->label = $label;

        return $this;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getType()
    {
        return $this->type;
    }

    public function setType($type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getValues()
    {
        return $this->values;
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function getLinkedWith()
    {
        return $this->linkedWith;
    }

    public function getOption($option, $returnValue=null)
    {
        return $this->options[$option] ?? $returnValue;
    }
}
