<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 20/09/2018
 * Time: 09:40
 */

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: "diaporama_elements")]
#[ORM\Entity]
class DiaporamaElements
{
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: "IDENTITY")]
    #[ORM\Column(name: "id", type: "bigint", nullable: false)]
    private ?int $id = null;

    #[ORM\Column(name: "id_diaporama", type: "bigint", nullable: false)]
    private int $idDiaporama;

    #[ORM\Column(name: "file_name", type: "text", nullable: false)]
    private string $fileName;

    #[ORM\Column(name: "link", type: "text", nullable: false)]
    private string $link;

    #[ORM\Column(name: "alt", type: "text", nullable: false)]
    private string $alt;

    #[ORM\Column(name: "target", type: "text", nullable: false)]
    private string $target;

    #[ORM\Column(name: "date", type: "datetime", nullable: false)]
    private \DateTime $date;

    #[ORM\Column(name: "visible", type: "boolean", nullable: false)]
    private bool $visible;

    #[ORM\Column(name: "sortOrder", type: "bigint", nullable: false)]
    private int $sortorder;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getIdDiaporama(): int
    {
        return $this->idDiaporama;
    }

    /**
     * @param int $idDiaporama
     */
    public function setIdDiaporama(int $idDiaporama)
    {
        $this->idDiaporama = $idDiaporama;
    }

    /**
     * @return string
     */
    public function getFileName(): string
    {
        return $this->fileName;
    }

    /**
     * @param string $fileName
     */
    public function setFileName(string $fileName)
    {
        $this->fileName = $fileName;
    }

    /**
     * @return string
     */
    public function getLink(): string
    {
        return $this->link;
    }

    /**
     * @param string $link
     */
    public function setLink(string $link)
    {
        $this->link = $link;
    }

    /**
     * @return string
     */
    public function getAlt(): string
    {
        return $this->alt;
    }

    /**
     * @param string $alt
     */
    public function setAlt(string $alt)
    {
        $this->alt = $alt;
    }

    /**
     * @return string
     */
    public function getTarget(): string
    {
        return $this->target;
    }

    /**
     * @param string $target
     */
    public function setTarget(string $target)
    {
        $this->target = $target;
    }

    /**
     * @return \DateTime
     */
    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     */
    public function setDate(\DateTime $date)
    {
        $this->date = $date;
    }

    /**
     * @return bool
     */
    public function isVisible(): bool
    {
        return $this->visible;
    }

    /**
     * @param bool $visible
     */
    public function setVisible(bool $visible)
    {
        $this->visible = $visible;
    }

    /**
     * @return int
     */
    public function getSortorder(): int
    {
        return $this->sortorder;
    }

    /**
     * @param int $sortorder
     */
    public function setSortorder(int $sortorder)
    {
        $this->sortorder = $sortorder;
    }


}
