<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;


#[ORM\Table(name: 'accueil')]
#[ORM\Index(name: 'accueil_desc', columns: ['accueil_desc'])]
#[ORM\Index(name: 'accueil_mot', columns: ['accueil_mot'])]
#[ORM\Index(name: 'accueil_titre', columns: ['accueil_titre'])]
#[ORM\Entity]
class Accueil
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer')]
    private int $accueilLang = 1;

    #[ORM\Column(name: "accueil_titre", type: "string", length: 255, nullable: true)]
    private ?string $accueilTitre = null;

    #[ORM\Column(name: "accueil_desc", type: "string", length: 255, nullable: true)]
    private ?string $accueilDesc = null;

    #[ORM\Column(name: "accueil_mot", type: "string", length: 255, nullable: true)]
    private ?string $accueilMot = null;

    #[ORM\Column(name: "accueil_text", type: "text", nullable: true)]
    private ?string $accueilText = null;

    #[ORM\Column(name: "accueil_mentions", type: "text", nullable: true)]
    private ?string $accueilMentions = null;

    #[ORM\Column(name: "accueil_regles", type: "text", nullable: false)]
    private string $accueilRegles;

    /**
     * @return int
     */
    public function getAccueilLang()
    {
        return $this->accueilLang;
    }

    /**
     * @param int $accueilLang
     */
    public function setAccueilLang($accueilLang)
    {
        $this->accueilLang = $accueilLang;
    }

    /**
     * @return string|null
     */
    public function getAccueilTitre()
    {
        return $this->accueilTitre;
    }

    /**
     * @param string|null $accueilTitre
     */
    public function setAccueilTitre($accueilTitre)
    {
        $this->accueilTitre = $accueilTitre;
    }

    /**
     * @return string|null
     */
    public function getAccueilDesc()
    {
        return $this->accueilDesc;
    }

    /**
     * @param string|null $accueilDesc
     */
    public function setAccueilDesc($accueilDesc)
    {
        $this->accueilDesc = $accueilDesc;
    }

    /**
     * @return string|null
     */
    public function getAccueilMot()
    {
        return $this->accueilMot;
    }

    /**
     * @param string|null $accueilMot
     */
    public function setAccueilMot($accueilMot)
    {
        $this->accueilMot = $accueilMot;
    }

    /**
     * @return string|null
     */
    public function getAccueilText()
    {
        return $this->accueilText;
    }

    /**
     * @param string|null $accueilText
     */
    public function setAccueilText($accueilText)
    {
        $this->accueilText = $accueilText;
    }

    /**
     * @return string|null
     */
    public function getAccueilMentions()
    {
        return $this->accueilMentions;
    }

    /**
     * @param string|null $accueilMentions
     */
    public function setAccueilMentions($accueilMentions)
    {
        $this->accueilMentions = $accueilMentions;
    }

    /**
     * @return string
     */
    public function getAccueilRegles()
    {
        return $this->accueilRegles;
    }

    /**
     * @param string $accueilRegles
     */
    public function setAccueilRegles($accueilRegles)
    {
        $this->accueilRegles = $accueilRegles;
    }


}
