<?php
/**
 * Created by IntelliJ IDEA.
 * User: damien
 * Date: 18/06/2017
 * Time: 13:08
 */

namespace Actigraph\ActipageBaseBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\Reference;

class ActipageModulePass implements CompilerPassInterface
{

    /**
     * You can modify the container here before it is dumped to PHP code.
     *
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        // always first check if the primary service is defined
        if (!$container->has('Actigraph\ActipageBaseBundle\Services\ActipageModuleChain')) {
            return;
        }
        $definition = $container->findDefinition('Actigraph\ActipageBaseBundle\Services\ActipageModuleChain');
        $taggedServices = $container->findTaggedServiceIds('actipage.module');
        foreach ($taggedServices as $id => $tags) {
            foreach ($tags as $attributes) {
                $definition->addMethodCall('addService', array(
                    new Reference($id),
                    $attributes["alias"]
                ));
            }
        }
    }
}