const util = require("./util");

if($("#formInscriptionActipageAlertesSMS").length>0){
    $('.addLigne').on("click",function (e) {
        e.preventDefault();
        if($("select[name='ligne']","#formInscriptionActipageAlertesSMS").val().length > 0){
            var canbeAdded = true;
            var ligneId = $("select[name='ligne']","#formInscriptionActipageAlertesSMS").val();
            var ligneNom = $("select[name='ligne'] option:selected","#formInscriptionActipageAlertesSMS").text();

            //recherche si pas déja ajouté dans la liste
            $.each($(".zonelignes ul li","#formInscriptionActipageAlertesSMS"),function(i,element){
                var currentLigneId=$(element).attr("data-ligneId");
                if(currentLigneId == ligneId){
                    alert("La ligne existe déja dans votre liste");
                    canbeAdded = false;
                }
            });
            if(canbeAdded){
                $('.zonelignes',"#formInscriptionActipageAlertesSMS").show();
                $(".zonelignes ul","#formInscriptionActipageAlertesSMS").append(generateLigneLigne(ligneId,ligneNom));
            }
        }

        return false;
    });
    $(".zonelignes").on("click",".removeLigne",function (e) {
        e.preventDefault();
        $(e.target).closest("li").remove()
        return false;
    });
    function generateLigneLigne(ligneId,ligneNom){
        var html = "<li data-ligneId='"+ligneId+"' class='list-group-item'>";
        html += '<strong>'+ligneNom+'</strong>';
        html += '<input type="hidden" name="'+ligneId+'|status" value="1">';
        html += '<a href="#" class="btn btn-danger btn-xs pull-right removeLigne">Supprimer</a></li>';

        return html;
    }

    $("#submitFormInscriptionActipageAlertesSMS").on("click",function (e) {
        e.preventDefault();
        var formIsValid = true;
        var messageErreur= "";
        let alreadyFocused=false;

        if($("#nom").val().trim() == ""){
            formIsValid=false;
            if(!alreadyFocused){
                $("#nom").focus();
                alreadyFocused=true;
            }
            messageErreur += "Vous devez saisir votre nom de famille\n";
        }
        if($("#prenom").val().trim() == ""){
            formIsValid=false;
            if(!alreadyFocused){
                $("#prenom").focus();
                alreadyFocused=true;
            }
            messageErreur += "Vous devez saisir votre prénom\n";
        }
        if(!util.validTelephone($("#tel").val())){
            formIsValid=false;
            if(!alreadyFocused){
                $("#tel").focus();
                alreadyFocused=true;
            }
            messageErreur += "Votre numéro de téléphone n'est pas valide\n";
        }
        if($(".zonelignes ul li").length == 0){
            formIsValid=false;
            if(!alreadyFocused){
                $("#ligne").focus();
                alreadyFocused=true;
            }
            messageErreur += "Vous devez sélectionner au moins une ligne\n";
        }
        if($("#newsletter").length > 0 && $("#newsletter").is(":checked")){
            if($("#mail").val().trim() == ""){
                formIsValid=false;
                if(!alreadyFocused){
                    $("#mail").focus();
                    alreadyFocused=true;
                }
                messageErreur += "Vous devez saisir votre adresse email (format attendu : nomprenom@mail.com)\n";
            }else{
                if(!util.validmail(document.formInscriptionActipageAlertesSMS.mail)){
                    formIsValid=false;
                    if(!alreadyFocused){
                        $("#mail").focus();
                        alreadyFocused=true;
                    }
                    messageErreur += "Votre adresse email n'est pas valide (format attendu : nomprenom@mail.com)\n";
                }
            }
        }

        if (typeof isRgpdAccepted === 'function') {
            if(!isRgpdAccepted("formInscriptionActipageAlertesSMS")) {
                messageErreur += "Vous devez accepter les données RGPD du formulaire."
                if(!alreadyFocused){
                    $("#rgpdAccepted").focus();
                    alreadyFocused=true;
                }
                formIsValid = false;
            }
        }
        if (typeof isCaptchaFilled !== "undefined") {
            if(!isCaptchaFilled("formInscriptionActipageAlertesSMS")){
                messageErreur += "Vous devez accepter le captcha";
                if(!alreadyFocused){
                        $("[title='reCAPTCHA']").focus();
                    alreadyFocused=true;
                }
                formIsValid = false;
            }
        }

        if(formIsValid){
            $("#formInscriptionActipageAlertesSMS").submit();
        }else{
            alert(messageErreur);
        }
        return false;
    });
}
if($("#formDesinscriptionActipageAlertesSMS").length>0) {

    $("#submitFormDesinscriptionActipageAlertesSMS").on("click",function (e) {
        e.preventDefault();
        var formIsValid = true;
        var messageErreur= "";
        let alreadyFocused=false;
        if($("#tel2").val() == ""){
            formIsValid=false;
            if(!alreadyFocused){
                $("#tel2").focus();
                alreadyFocused=true;
            }
            messageErreur += "Vous devez saisir un numéro de téléphone\n";
        }else{
            if($("#tel2").val() != "" && !util.validTelephone($("#tel2").val())){
                formIsValid=false;
                if(!alreadyFocused){
                    $("#tel2").focus();
                    alreadyFocused=true;
                }
                messageErreur += "Vous devez saisir un numéro de téléphone valide\n";
            }
        }
        if (typeof isRgpdAccepted === 'function') {
            if(!isRgpdAccepted("formDesinscriptionActipageAlertesSMS")) {
                messageErreur += "Vous devez accepter les données RGPD du formulaire."
                if(!alreadyFocused){
                    $("#rgpdAccepted").focus();
                    alreadyFocused=true;
                }
                formIsValid = false;
            }
        }
        if (typeof isCaptchaFilled !== "undefined") {
            if(!isCaptchaFilled("formDesinscriptionActipageAlertesSMS")){
                messageErreur += "Vous devez accepter le captcha";
                if(!alreadyFocused){
                        $("[title='reCAPTCHA']").focus();
                    alreadyFocused=true;
                }
                formIsValid = false;
            }
        }

        if(formIsValid){
            $("#formDesinscriptionActipageAlertesSMS").submit();
        }else{
            alert(messageErreur);
        }
        return false;
    });
}
