const util = require("./util");

if($("#submitCandidatureForm").length>0){
    $("#submitCandidatureForm").on("click",function(e) {
        e.preventDefault();
        var erreur = [];
        var formValid = true;
        let alreadyFocused=false;

        if(document.getElementById("theme").value == -1){
            erreur.push("Vous devez sélectionner une fonction");
                if(!alreadyFocused){
                    $("#theme").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("nom").value == 0){
            erreur.push("Vous devez renseigner votre nom de famille");
                if(!alreadyFocused){
                    $("#nom").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("prenom").value == 0){
            erreur.push("Vous devez renseigner votre prénom");
                if(!alreadyFocused){
                    $("#prenom").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("adresse").value == 0){
            erreur.push("Vous devez renseigner votre adresse");
                if(!alreadyFocused){
                    $("#adresse").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("cp").value == 0){
            erreur.push("Vous devez renseigner votre code postal (exemple : 75000)");
                if(!alreadyFocused){
                    $("#cp").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("ville").value == 0){
            erreur.push("Vous devez renseigner votre ville");
                if(!alreadyFocused){
                    $("#ville").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("telephone").value == 0){
            erreur.push("Vous devez renseigner votre numéro de téléphone");
                if(!alreadyFocused){
                    $("#telephone").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("mail").value == 0){
            erreur.push("Vous devez renseigner votre adresse email (format attendu : nomprenom@mail.com)");
                if(!alreadyFocused){
                    $("#mail").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }else{
            if(!util.validmail(document.candidature.mail)){
                erreur.push("Votre adresse email n'est pas valide (format attendu : nomprenom@mail.com)");
                if(!alreadyFocused){
                    $("#mail").focus();
                    alreadyFocused=true;
                }
                formValid = false;
            }
        }
        if($("input[name=fimo]:checked").val() == undefined){
            erreur.push("Vous devez répondre à la question FIMO/FCOS Voyageur");
                if(!alreadyFocused){
                    $("#fimooui").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if($("input[name=permisd]:checked").val() == undefined){
            erreur.push("Vous devez répondre à la question Permis D");
                if(!alreadyFocused){
                    $("#permisdoui").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.getElementById("cv").files.length == 0 && document.getElementById("formation").value == "" && document.getElementById("experience").value == "") {
            erreur.push("Si vous ne renseignez pas de CV, veuillez compléter les champs Formation et Expérience");
                if(!alreadyFocused){
                    $("#formation").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if (typeof isRgpdAccepted === 'function') {
            if(!isRgpdAccepted("candidature")) {
                erreur.push("Vous devez accepter les données RGPD du formulaire")
                if(!alreadyFocused){
                    $("#rgpdAccepted").focus();
                    alreadyFocused=true;
                }
                formValid = false;
            }
        }
        if (typeof isCaptchaFilled !== "undefined") {
            if(!isCaptchaFilled("candidature")){
                erreur.push("Vous devez accepter le captcha");
                if(!alreadyFocused){
                        $("[title='reCAPTCHA']").focus();
                    alreadyFocused=true;
                }
                formValid = false;
            }
        }

        if(!formValid)
            alert(erreur.join("\n"));
        else
            document.candidature.submit();
        return false;
    });
}