<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 17/09/2018
 * Time: 14:34
 */

namespace Actigraph\ActipageBaseBundle\Services;

use Symfony\Component\HttpFoundation\Session\SessionInterface;

class GooglePlacesService implements AdressAutocompleteInterface
{
    private $config,$contentSecurityPolicyNonceService;

    public function __construct(SessionInterface $session,ContentSecurityPolicyNonceService $contentSecurityPolicyNonceService, $config)
    {
        $this->config = $config;
        $this->contentSecurityPolicyNonceService = $contentSecurityPolicyNonceService;
    }

    public function getAutocompleteHtml()
    {
        return "
            <script nonce='".$this->contentSecurityPolicyNonceService->getNonce()."' src=\"https://maps.googleapis.com/maps/api/js?key=".$this->config["key"]."&signed_in=true&libraries=places&callback=initMap\" async defer></script>
           <script nonce='".$this->contentSecurityPolicyNonceService->getNonce()."' type=\"text/javascript\">
                function initMap() {
                    var autocomplete = document.getElementsByClassName(\"autocompleteaddress\");
                    for (var i = 0; i < autocomplete.length; i++) {
                             new google.maps.places.Autocomplete(autocomplete[i]);
                    }
                };
            </script>";
    }

}