<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 17/09/2018
 * Time: 14:33
 */

namespace Actigraph\ActipageBaseBundle\Services;

use Symfony\Component\HttpFoundation\Session\SessionInterface;

class AddressAutocompleteService
{
    /** @var AdressAutocompleteInterface $autocomplete */
    private $autocomplete;

    public function __construct($params, SessionInterface $session,ContentSecurityPolicyNonceService $contentSecurityPolicyNonceService) {
        if(isset($params["autocompleteApi"])){
            if($params["autocompleteApi"]["type"] == "googleplace"){
                $config = $params["autocompleteApi"]["config"];
                $this->autocomplete = new GooglePlacesService($session,$contentSecurityPolicyNonceService, $config);
            }
        }
    }

    public function getHtmlAutocomplete(){
        if($this->autocomplete != null)
        return $this->autocomplete->getAutocompleteHtml();
    }

}