<?php
/**
 * Created by IntelliJ IDEA.
 * User: damien
 * Date: 11/01/2017
 * Time: 22:31
 */

namespace Actigraph\ActipageBaseBundle\Services;

use Actigraph\ActipageBaseBundle\Entity\Diaporama;
use Actigraph\ActipageBaseBundle\Entity\DiaporamaElements;
use Actigraph\ActipageBaseBundle\Entity\Langues;
use Actigraph\ActipageBaseBundle\Entity\Objets;
use Actigraph\ActipageBaseBundle\Entity\Pages;
use Actigraph\ActipageModulesReferentiel\FrontModules;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query\ResultSetMappingBuilder;
use GuzzleHttp\Client;
use Hashids\Hashids;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Config\Definition\Exception\Exception;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Intl\Exception\NotImplementedException;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Translation\TranslatorInterface;

class ActipageService
{
    public const ACTYTYPESEARCH_BULLETINALERTE=0;
    public const ACTYTYPESEARCH_ACTU=1;
    public const ACTYTYPESEARCH_INFOTRAFIC=2;
    public const ACTYTYPESEARCH_PREHOME=3;
    public const ACTYTYPESEARCH_ALERTE = 4;
    public const ACTYTYPESEARCH_MAINTENANCE = 5;


    private $params;
    private $defaultLang;
    private $session;
    private $doctrine;
    private $hashids;
    private $requestStack;
    private $router;
    private $extendActipage;
    private $contentSecurityPolicyNonceService;
    /** @var DataEncryptionService $dataEncryptionService */
    private $dataEncryptionService;
    /** @var TranslatorInterface $translator */
    private $translator;

    public function __construct(SessionInterface $session,$params,EntityManagerInterface $doctrine,RouterInterface $router,RequestStack $requestStack,ActipageModuleService $actipageModuleService, ContentSecurityPolicyNonceService $contentSecurityPolicyNonceService,TranslatorInterface $translator,$locale, DataEncryptionService $dataEncryptionService)
    {
        $this->session = $session;
        $this->params = $params;
        $this->doctrine = $doctrine;
        $this->requestStack = $requestStack;
        $this->router = $router;
        $this->contentSecurityPolicyNonceService = $contentSecurityPolicyNonceService;
        $this->translator = $translator;
        $this->defaultLang = $locale;
        $this->dataEncryptionService = $dataEncryptionService;

        $idObfuscatorSeed ="";
        if(isset($this->params["idObfuscatorSeed"]))
            $idObfuscatorSeed =$this->params["idObfuscatorSeed"];
        $this->hashids = new Hashids($idObfuscatorSeed);
        if(class_exists('App\Extend\ExtendActipage')) {
            $this->extendActipage = new \App\Extend\ExtendActipage(
                $this->requestStack,
                $this->session,
                $this->doctrine,
                $this,
                $actipageModuleService
            );
        }
    }

    /**
     * @param $methode string
     * @param $params array
     * @return mixed
     */
    public function handleExtend($methode,$params=array()){
        if($this->hasExtend($methode))
            return call_user_func_array(array($this->extendActipage, $methode), $params);
        return null;
    }

    /**
     * @param $methode
     * @return bool
     */
    public function hasExtend($methode){
        if($this->extendActipage != null && method_exists($this->extendActipage,$methode))
            return true;
        return false;
    }

    public function getSiteConfigForModule($moduleName,$default=array()){
        if(isset($this->params[$moduleName]))
            return $this->params[$moduleName];
        return $default;
    }

    public function getSiteParams(){
        return $this->params;
    }

    public function getSessionPreHome(){
        return $this->session->get("prehomeView",false);
    }

    public function setSessionPreHome($bool){
        $this->session->set("prehomeView", $bool);
    }


    public function setRequestedLang($lang){

        $this->session->set("requestedLang",$lang);
        //dump($this->session->get("requestedLang")); exit;

        return;
    }


    public function checkLangueInfo($failBackLang = false){
        //Calcul du shortcode à partir des préférences du systéme de l'utilisateur, des langues géré par le systéme et de l'url (url surpase les autres sources)

        /*$this->session->remove('requestedLang');
        $this->session->remove('currentShortcode');*/

        $shortcode = $this->session->get("requestedLang");
        if($this->session->get("isMobileLang",false)){ //si j'ai demandé un mobile dans l'url alors je l'ajoute dans la langue de l'utilisateur
            $shortcode = "mobile-".$shortcode;
        }

        $previousShortcode = $this->session->get("currentShortcode","");

        //if($previousShortcode == $shortcode) //Si c'est la même que la précédre pas la peine d'aller plus loin
        //    return true;
        $em = $this->doctrine;
        $sql = 'SELECT langues.langue_id,langues.langue_lib,langues.langue_mere, langues.langue_shortcode_ref FROM langues WHERE langue_shortcode = :shortcode';
        $query = $em->getConnection()->prepare($sql);
        $query->execute(array("shortcode"=>$shortcode));
        $langue = $query->fetchAll();

        if(count($langue) == 0) {
            if($this->defaultLang != "" && $failBackLang){
                $shortcode = $this->defaultLang;
                $sql = 'SELECT langues.langue_id,langues.langue_lib,langues.langue_mere, langues.langue_shortcode_ref FROM langues WHERE langue_shortcode = :shortcode';
                $query = $em->getConnection()->prepare($sql);
                $query->execute(array("shortcode"=>$shortcode));
                $langue = $query->fetchAll();
                $langue = $langue[0];
            } else {
                return false;
            }
        } else {
            $langue =$langue[0];
        }

        $this->session->set("currentShortcodeRef", $langue["langue_shortcode_ref"]);
        $this->session->set("currentShortcode",$shortcode);
        $this->session->set("langId",$langue["langue_id"]);
        $this->session->set("langMereId",$langue["langue_mere"]);
        if($langue["langue_shortcode_ref"] != "" && strlen($langue["langue_shortcode_ref"]) == 2)
            $this->translator->setLocale($langue["langue_shortcode_ref"]);
        return true;
    }

    public function getCurrentLangueId(){
        return $this->session->get("langId");
    }
    public function getCurrentMereLangueId(){
        if($this->session->get("langMereId") == 0)
            return $this->session->get("langId");
        return $this->session->get("langMereId");
    }
    public function isMobileLangue(){
        return $this->session->get("isMobileLang",false);
    }
    public function getCurrentLangueShortCode()
    {
        return $this->session->get("currentShortcode");
    }

    public function getCurrentLangueShortCodeRef()
    {
        return $this->session->get("currentShortcodeRef");
    }

    public function getIdTypeByNameTypeActu($const_nameTypeActu){
        if($const_nameTypeActu == self::ACTYTYPESEARCH_BULLETINALERTE){
            $nameTypeActu="bulletin d'alerte";
        } else if($const_nameTypeActu == self::ACTYTYPESEARCH_PREHOME) {
            $nameTypeActu="Pré home Actualité";
        } else if($const_nameTypeActu == self::ACTYTYPESEARCH_ALERTE){
            $nameTypeActu="Pré home Alerte";
        } else if($const_nameTypeActu == self::ACTYTYPESEARCH_MAINTENANCE){
            $nameTypeActu="Maintenance";
        }

        $nameType = strtolower($nameTypeActu);
        $em = $this->doctrine;
        $repository = $em->getRepository('ActigraphActipageBaseBundle:TypeActu');
        $typeActu = $repository->findOneBy(array("nomTypeActu"=>$nameType));

        if($typeActu !== null)
            return $typeActu->getIdTypeActu();
        return false;
    }

    public function getCurrentMaintenance(){
        $idTypeMaintenance = $this->getIdTypeByNameTypeActu(self::ACTYTYPESEARCH_MAINTENANCE);
        if(!$idTypeMaintenance)
            return false;

        $params = array("objLang"=>$this->getCurrentLangueId(),"datedujour"=>date("Y-m-d H:i:s"),"idTypeActu"=>$idTypeMaintenance);
        $sqlActu = 'SELECT * FROM `actus` WHERE actu_lang=:objLang AND (actu_date_deb <= :datedujour AND actu_date_fin >= :datedujour) AND  id_type_actu = :idTypeActu ';
        $queryActu = $this->doctrine->getConnection()->prepare($sqlActu);
        $queryActu->execute($params);
        $tmpResultsActu = $queryActu->fetch();
        // dump($tmpResultsActu);
        if($tmpResultsActu != null){
            return array(
                "id"=>$tmpResultsActu["actu_id"],
                "titre"=>$tmpResultsActu["actu_titre"],
                "texte"=>$tmpResultsActu["actu_texte"],
            );
        }
        return false;
    }
    public function getActualitesByTypeId($idTypeActu)
    {
        $dateDuJour = date("Y-m-d H:i:s");
        $allIdTypeActu = explode(',',$idTypeActu);
        $em = $this->doctrine;
        $repository = $em->getRepository('ActigraphActipageBaseBundle:Actus');
        $query = $repository->createQueryBuilder('a')
            ->where('a.idTypeActu IN (:typeActu)')
            ->andWhere("a.actuLang = :langId")
            ->andWhere("a.actuDateDeb <= :datedujour")
            ->andWhere("a.actuDateFin >= :datedujour")
            ->setParameter('typeActu', $allIdTypeActu)
            ->setParameter('langId', $this->getCurrentMereLangueId())
            ->setParameter('datedujour', $dateDuJour)
            ->orderBy('a.actuDateDeb', 'DESC')
            ->getQuery();

        return $query->getResult();
    }

    /**
     * @param $idDiapo
     * @return DiaporamaElements[]
     */
    public function getElementDiapoById($idDiapo){
        $em = $this->doctrine;
        $repositoryDiapoElements = $em->getRepository('ActigraphActipageBaseBundle:DiaporamaElements');
        return $repositoryDiapoElements->findBy(array("idDiaporama"=>$idDiapo,"visible"=>1),array("sortorder"=>"ASC"));
    }

    /**
     * @param $idDiapo
     * @return Diaporama
     */
    public function getInfosDiapo($idDiapo){
        $em = $this->doctrine;
        $repositoryDiapoElements = $em->getRepository('ActigraphActipageBaseBundle:Diaporama');
        return $repositoryDiapoElements->findOneBy(array("id"=>$idDiapo));
    }

    public function recherche($text,$option=array()){
        //TODO gestion des accents a retirer

        $resultatsRecherche = array();
        if(count($option)==0){
            $option=array("titre","desc","mot","contenu","exact","actu");
        }

        $params = array("objLang"=>$this->getCurrentLangueId(),"datedujour"=>date("Y-m-d H:i:s"));
        if(!in_array("exact",$option)){
            $listText = explode(" ",$text);
            $numTexts=0;
            foreach ($listText as $tmp){
                $params["text_".$numTexts] = "%".$tmp."%";
                $numTexts++;
            }
        }else{
            $params["text"] = "%".$text."%";
        }

        $em = $this->doctrine;

        //Actualités
        if(in_array("actu",$option)){
            $sqlActu = 'SELECT * FROM `actus` WHERE actu_lang=:objLang AND (actu_date_deb <= :datedujour AND actu_date_fin >= :datedujour) AND ( ';
            $sqlWhere=array();
            if(!in_array("exact",$option)){
                for($i=0;$i<$numTexts;$i++){
                    $sqlWhere[] = "actu_titre LIKE :text_".$i;
                    $sqlWhere[] = "actu_accroche LIKE :text_".$i;
                    $sqlWhere[] = "actu_texte LIKE :text_".$i;
                }
            }else{
                $sqlWhere[] = "actu_titre LIKE :text";
                $sqlWhere[] = "actu_accroche LIKE :text";
                $sqlWhere[] = "actu_texte LIKE :text";
            }
            $sqlActu .= implode(" OR ",$sqlWhere)." )";
            $queryActu = $em->getConnection()->prepare($sqlActu);
            $queryActu->execute($params);
            //TODO gerer les redirections externe de l'actu

            $tmpResultsActu = $queryActu->fetchAll();
            foreach ($tmpResultsActu as $resultActu){
                $resultatsRecherche[]=array(
                    "titre"=>$resultActu["actu_titre"],
                    "url"=>$this->generatePath("detail_actu",array("idEncoded"=>$this->encodeId($resultActu["actu_id"]))),
                    "preview"=>$this->previewSearchResult($resultActu["actu_texte"],$text)
                );
            }
        }


        //Pages
        $sql = 'SELECT o.*, p.* FROM objets o JOIN pages p ON p.page_pere = o.obj_id WHERE o.obj_visu=1 AND o.obj_lang=:objLang AND (p.perenne = 1 OR (p.page_deb <= :datedujour AND p.page_fin >= :datedujour) ) AND ( ';
        $sqlWhere=array();
        //recherche dans les titres des pages
        if(in_array("titre",$option)){
            if(!in_array("exact",$option)){
                for($i=0;$i<$numTexts;$i++){
                    $sqlWhere[] = "p.`page_titre` LIKE :text_".$i;
                }
            }else
                $sqlWhere[] = "p.`page_titre` LIKE :text";
        }
        //recherche dans la description des pages
        if(in_array("desc",$option)){
            if(!in_array("exact",$option)){
                for($i=0;$i<$numTexts;$i++){
                    $sqlWhere[] = "p.`page_desc` LIKE :text_".$i;
                }
            }else
                $sqlWhere[] = "p.`page_desc` LIKE :text";
        }
        //recherche dans les mots clées des pages
        if(in_array("mot",$option)){
            if(!in_array("exact",$option)){
                for($i=0;$i<$numTexts;$i++){
                    $sqlWhere[] = "p.`page_mot` LIKE :text_".$i;
                }
            }else
                $sqlWhere[] = "p.`page_mot` LIKE :text";
        }
        //recherche dans le contenu des pages
        if(in_array("contenu",$option)){
            if(!in_array("exact",$option)){
                for($i=0;$i<$numTexts;$i++){
                    $sqlWhere[] = "p.`page_text` LIKE :text_".$i;
                }
            }else
                $sqlWhere[] = "p.`page_text` LIKE :text";
        }

        $sql .= implode(" OR ",$sqlWhere)." )";
        $query = $em->getConnection()->prepare($sql);
        $query->execute($params);

        $tmpResults = $query->fetchAll();
        foreach ($tmpResults as $resultPage){
            $resultatsRecherche[]=array(
                "titre"=>$resultPage["page_titre"],
                "url"=>$this->generateUrlForRawObjet($resultPage),
                "preview"=>$this->previewSearchResult($resultPage["page_text"],$text)
            );
        }

        //Mentions légales et accueil
        $sqlLegal = 'SELECT * FROM `accueil` WHERE accueil_lang=:objLang AND ( ';
        $sqlWhere=array();
        if(!in_array("exact",$option)){
            for($i=0;$i<$numTexts;$i++){
                $sqlWhere[] = "accueil_mentions LIKE :text_".$i;
            }
        }else{
            $sqlWhere[] = "accueil_mentions LIKE :text";
        }
        $sqlLegal .= implode(" OR ",$sqlWhere)." )";
        $queryLegal = $em->getConnection()->prepare($sqlLegal);
        $paramsLegal = $params;
        unset($paramsLegal["datedujour"]);
        $queryLegal->execute($paramsLegal);
        $tmpResultsLegal = $queryLegal->fetchAll();
        foreach ($tmpResultsLegal as $resultLegal){
            $resultatsRecherche[]=array(
                "titre"=>$this->translator->trans("titre.legal"),
                "url"=>$this->generatePath("legal"),
                "preview"=>$this->previewSearchResult($resultLegal["accueil_mentions"],$text)
            );
        }

        return $resultatsRecherche;
    }
    private function previewSearchResult($textComplet, $recherche){
        $return ="";
        $contenu_rech = $textComplet;
        while (stristr($contenu_rech,$recherche)){
            //TODO gestion de la suppression des accents
            $trouve=stristr($contenu_rech,$recherche);

            $sp=explode($trouve,$contenu_rech);

            $trouve2=str_replace($recherche,'<mark>'.$recherche.'</mark>',$trouve);

            $tab1=explode(' ',$sp[0]);
            $s1=count($tab1);
            $tab2=explode(' ',$trouve2);
            $s2=count($tab2);
            $nb_mot=15;
            if ($s1<$nb_mot) $n1=$s1;
            else $n1=$nb_mot;
            if ($s2<$nb_mot) $n2=$s2;
            else $n2=$nb_mot;

            $return .= '(...) ';
            for ($k=0;$k<$n1;$k++){
                $return .= $tab1[$s1-$n1+$k].' ';
            }
            for ($l=0;$l<$n2;$l++){
                $return .= $tab2[$l].' ';
            }
            $return .= ' (...)<hr>';

            $contenu_rech=substr($trouve,strlen($recherche)-1);

        }
        return $return;
    }

    public function getPage($id, $forceVisibility = false){
        //TODO ajout param permettant forcage page
        $em = $this->doctrine;

        $rsm = new ResultSetMappingBuilder($em);
        $rsm->addRootEntityFromClassMetadata('ActigraphActipageBaseBundle:Objets', 'o');
        $rsm->addJoinedEntityFromClassMetadata('ActigraphActipageBaseBundle:Pages', 'p', 'o', 'page', array('pagePere' => 'objId'));
        $sql = 'SELECT '.$rsm.' FROM objets o LEFT JOIN pages p ON p.page_pere = o.obj_id WHERE o.obj_id = ? AND o.obj_lang = ?';
        $query = $em->createNativeQuery($sql, $rsm);
        $query->setParameter(1, $this->decodeId($id));
        $query->setParameter(2, $this->getCurrentLangueId());

        try{
            $objet = $query->getOneOrNullResult();

            if($objet != null)
                $objet = $this->recursiveFindPage($objet, $forceVisibility);
            return $objet;
        } catch (\Doctrine\ORM\NonUniqueResultException $exception){

            return null;
        }
    }

    public function recursiveFindPage(Objets $objet, $forceVisibility = false){
        if($this->isObjetVisable($objet, $forceVisibility))
            return $objet;
        $em = $this->doctrine;

        $rsm = new ResultSetMappingBuilder($em);

        $rsm->addRootEntityFromClassMetadata('ActigraphActipageBaseBundle:Objets', 'o');
        $rsm->addJoinedEntityFromClassMetadata('ActigraphActipageBaseBundle:Pages', 'p', 'o', 'page', array('pagePere' => 'objId'));
        $sql = 'SELECT '.$rsm.' FROM objets o LEFT JOIN pages p ON p.page_pere = o.obj_id WHERE o.obj_pere = ? AND o.obj_visu = 1 ORDER BY obj_ordre ASC';

        $query = $em->createNativeQuery($sql, $rsm);
        $query->setParameter(1, $objet->getObjId());
        $objets = $query->getResult();

        $returnObjet = null;
        foreach ($objets as $objet){
            if($returnObjet != null)
                continue;

            if($objet->getObjPage() == 1){
                if($this->isObjetVisable($objet))
                    $returnObjet = $objet;
            }else{
                $returnRecu = $this->recursiveFindPage($objet);
                $returnObjet = $returnRecu;
            }
        }

        return $returnObjet;
    }

    public function isObjetVisable(Objets $objet, $forceVisibility = false){
        if($forceVisibility)
            return true;
        if($objet->getObjPage() == 1){
            /** @var Pages $page */
            $page = $objet->getPage();

            if($page->getPerenne()){
                if($objet->getObjVisu() == 1){
                    return true;
                } else {
                    if($page->getBloquageReferencement() == 0)
                        return true;
                    else
                        return false;
                }
            } else {
                if($page->getPageDeb()->getTimestamp() < time() &&  time() < $page->getPageFin()->getTimestamp()){
                    return true;
                } else {
                    return false;
                }
            }

        }
        return false;
    }

    public function getCurrentPage(){
        $request = $this->requestStack->getMasterRequest();
        /** @var Objets $current_object */
        $current_object = $request->attributes->get("current_object",null);
        if($current_object != null)
            return $this->encodeId($current_object->getObjId());
        return false;
    }


    // Fonction qui génère le siteMapXML avec toutes les langues
    public function generateSiteMapXML(){
        $em = $this->doctrine;

        $sql = 'SELECT p.*, o.* FROM objets o LEFT JOIN pages p ON p.page_pere = o.obj_id WHERE o.obj_visu = 1 AND p.bloquage_referencement = 0 ORDER BY obj_ordre ASC';
        $query = $em->getConnection()->prepare($sql);
        $query->execute();
        $listeArbo = $query->fetchAll();
        $today=date("Y-m-d H:i:s");
        $arbo = Array();
        $accueil = $em->getRepository('ActigraphActipageBaseBundle:Accueil')->findAll();

        foreach ($accueil as $ac){
            $langue = $em->getRepository('ActigraphActipageBaseBundle:Langues')->findOneBy(array("langueId"=>$ac->getAccueilLang()));
            $objets = $em->getRepository('ActigraphActipageBaseBundle:Objets')->findBy(array("objLang"=>$ac->getAccueilLang()));
            $allObjetVisable = array();
            foreach ($objets as $objet){
                if($this->isObjetVisable($objet)){
                    array_push($allObjetVisable, $objet);
                }
            }

            if(!empty($allObjetVisable)) {
                $arbo [] = array(
                    "url" => "/" . $langue->getLangueShortcode() . "/"
                );
                $arbo [] = array(
                    "url" => "/" . $langue->getLangueShortcode() . "/legal"
                );
            }
        }
        if(count($listeArbo)>0){
            foreach ($listeArbo as $page){

                $tmpObj = new Objets();
                $tmpObj->setObjLang($page["obj_lang"]);

                $repositoryLangues = $em->getRepository('ActigraphActipageBaseBundle:Langues');
                $languesPages = $repositoryLangues->findOneBy(array("langueId"=>$tmpObj->getObjLang()));
                $lang = $languesPages->getLangueShortCode();
                if($lang == "")
                    continue;

                if($page["perenne"] == 0){
                    if($page["date_fin"] < $today || $page["date_deb"] > $today){
                        continue;
                    }
                }
                $url = $this->generateUrlForRawObjet($page, true);
                $arbo [] = array(
                    "url"=>$url
                );
            }
        }

        return $arbo;
    }

    public function generateArbo($ignoreHiddenParent = false)
    {
        $request = $this->requestStack->getMasterRequest();
        $current_object = $request->attributes->get("current_object",null);
        $listeIdsActive = [];
        if ($current_object) {
            $listeIdsActive = $this->generateAllParentsFromObjet($current_object,true);
            //dump($listeIdsActive); exit;
        }
        $em = $this->doctrine;
        $sql = 'SELECT p.*, o.* FROM objets o LEFT JOIN pages p ON p.page_pere = o.obj_id WHERE o.obj_pere = :objPere AND o.obj_lang = :objLang ORDER BY obj_ordre ASC';
        $query = $em->getConnection()->prepare($sql);
        $arbo = $this->generateArboLoop([], $listeIdsActive, $query,0, 0, $ignoreHiddenParent);

        return $arbo;
    }

    private function generateArboLoop($arbo,$listeIdsActive,$query,$currentObjId,$profondeur=0, $ignoreHiddenParent = false)
    {
        $params = [
            "objPere" => $currentObjId,
            "objLang" => $this->getCurrentLangueId(),
        ];
        $fileName = __DIR__.'/../../../../var/cache/arbo/objets_'.$currentObjId.'_'.$this->getCurrentLangueId().'.cache';

        if (!is_dir(__DIR__.'/../../../../var/cache/arbo')) {
            mkdir(__DIR__.'/../../../../var/cache/arbo');
        }
        if (file_exists($fileName)) {
            // Récupère la date de dernière modification du fichier
            $lastModifiedTime = filemtime($fileName);

            // Vérifie si le fichier a été modifié il y a plus de 60 secondes
            if (time() - $lastModifiedTime > 60) {
                // Met à jour le contenu du fichier
                $query->execute($params);
                $listeSousObjets = $query->fetchAll();
                file_put_contents($fileName, serialize($listeSousObjets));
            } else {
                $listeSousObjets = unserialize(file_get_contents($fileName));
            }
        } else {
            $query->execute($params);
            $listeSousObjets = $query->fetchAll();
            file_put_contents($fileName, serialize($listeSousObjets));
        }

//        $query->execute($params);
//        $listeSousObjets = $query->fetchAll();

        $em = $this->doctrine;
        $today=date("Y-m-d H:i:s");
        if (count($listeSousObjets) > 0) {
            foreach ($listeSousObjets as $sousObjet) {
                $fileName = __DIR__.'/../../../../var/cache/arbo/objet_'.$sousObjet["obj_id"].'.cache';

                if (!is_dir(__DIR__.'/../../../../var/cache/arbo')) {
                    mkdir(__DIR__.'/../../../../var/cache/arbo');
                }
                if (file_exists($fileName)) {
                    // Récupère la date de dernière modification du fichier
                    $lastModifiedTime = filemtime($fileName);

                    // Vérifie si le fichier a été modifié il y a plus de 60 secondes
                    if (time() - $lastModifiedTime > 60) {
                        // Met à jour le contenu du fichier
                        $objet = $em->getRepository('ActigraphActipageBaseBundle:Objets')->findOneBy(array("objId" => $sousObjet["obj_id"]));
                        file_put_contents($fileName, serialize($objet));
                    } else {
                        $objet = unserialize(file_get_contents($fileName));
                    }
                } else {
                    $objet = $em->getRepository('ActigraphActipageBaseBundle:Objets')->findOneBy(array("objId" => $sousObjet["obj_id"]));
                    file_put_contents($fileName, serialize($objet));
                }
                /** @var Objets $objet **/
                $page = $objet->getPage();
                $class = array("default");
                if (count(explode("|", $sousObjet["obj_class"])) == 2) {
                    $tmp = explode("|", $sousObjet["obj_class"]);
                    $class[] = $tmp[0];
                }
                if (in_array($sousObjet["obj_id"], $listeIdsActive)) {
                    $class[] = "active";
                }
                $isDossier = true;

                $typeUrl = "interne";
                if ($page != null) {
                    if ($page->getPageLien() != "" && $page->getPageActivLien() == 0) {
                        $typeUrl = "externe";
                    }
                }

                if ($sousObjet["obj_page"] == 1) {
                    $isDossier = false;
                    //C'est une page c'est peut etre une redirection ou une page non visible car date visibilité dépassé
                    if ($sousObjet["perenne"] == 0) {
                        if ($sousObjet["date_fin"] < $today || $sousObjet["date_deb"] > $today) {
                            if(!$ignoreHiddenParent || $sousObjet["obj_page"] == 1)
                                continue;

                        }
                    }
                    if ($sousObjet["obj_visu"] == 0 || $sousObjet["obj_titre"] == "")
                        if(!$ignoreHiddenParent || $sousObjet["obj_page"] == 1)
                            continue;

                    $url = $this->generateUrlForRawObjet($sousObjet);
                } else {
                    if ($sousObjet["perenne"] == 0) {
                        if ($sousObjet["date_fin"] < $today || $sousObjet["date_deb"] > $today) {
                            if(!$ignoreHiddenParent || $sousObjet["obj_page"] == 0 && !(in_array($sousObjet["obj_id"], $listeIdsActive)))
                                continue;

                        }
                    }
                    if ($sousObjet["obj_visu"] == 0 || $sousObjet["obj_titre"] == "")
                        if(!$ignoreHiddenParent || $sousObjet["obj_page"] == 0 && !(in_array($sousObjet["obj_id"], $listeIdsActive)))
                            continue;

                    $url = $this->generateUrlForRawObjet($sousObjet);
                }

                $pageTitre = '';
                if ($page != null) {
                    $pageTitre = $page->getPageTitre();
                }

                $arbo[$sousObjet["obj_id"]] = array(
                    "id" => $sousObjet["obj_id"],
                    "profondeur" => $profondeur,
                    "class" => $class,
                    "url" => $url,
                    "type" => $typeUrl,
                    "titre" => $sousObjet["obj_titre"],
                    "page_titre" => $pageTitre,
                    "isDossier" => $isDossier,
                    "enfants" => $this->generateArboLoop(array(), $listeIdsActive, $query, $sousObjet["obj_id"],$profondeur + 1, $ignoreHiddenParent)
                );
            }

            return $arbo;
        }

        return [];
    }

    public function generateAllParentsFromObjet(Objets $objet,$idsOnly=false){
        //TODO peut etre optimisé pour gagné 2 requéte en créan un cache car les même données sont necessaires pour la génération de l'arbo
        if($idsOnly)
            $listeParents = array($objet->getObjId());
        else
            $listeParents = array($objet);

        $currentObjet = $objet;
        do {
            $currentObjet = $this->findParentFromObjet($currentObjet);
            if($currentObjet){
                /** @var Objets $currentObjet */
                if($idsOnly)
                    $listeParents[]=$currentObjet->getObjId();
                else
                    $listeParents[]=$currentObjet;
            }
        }while($currentObjet != false);

        return $listeParents;
    }
    private function findParentFromObjet(Objets $objet){
        if($objet->getObjPere() == 0)
            return false;

        $em = $this->doctrine;
        /** @var Objets $objet */
        $objet= $em->getRepository('ActigraphActipageBaseBundle:Objets')->findOneBy(array("objId"=>$objet->getObjPere()));
        if($objet){
            return $objet;
        }else
            return null;
    }

    public function findPageWithModuleClass($classModule, $returnAccueilIfNotFound=true, $returnUrlOfPage=true)
    {
        $em = $this->doctrine;
        $sql = "SELECT objets.*, pages.page_titre, pages.page_id
            FROM pages
            JOIN module_liste ON pages.page_externe = module_liste.id_module
            JOIN objets ON objets.obj_id = pages.page_pere
            WHERE module_liste.classModule_front = :classModule AND objets.obj_lang = :langueId LIMIT 1";
        $query = $em->getConnection()->prepare($sql);
        $query->execute(array(
            "classModule"=>$classModule,
            "langueId"=>$this->getCurrentLangueId(),
        ));

        $selectedObject = false;

        if ($query->rowCount() > 0) {
            $objets = $query->fetchAll();
            foreach ($objets as $objet) {
                //TODO controle s'il n'y a une redirection externe de la page
                if ($objet["perenne"] == 0) {
                    $today = date("Y-m-d H:i:s");
                    if ($objet["date_fin"] < $today || $objet["date_deb"] > $today) {
                        continue;
                    }
                    if ($objet["date_deb"] <  $today && $today < $objet["date_fin"]) //uniquement si je suis dans la publication je le met de coté
                        $selectedObject = $objet; //TODO check si ça marche bien
                } else
                    $selectedObject = $objet;
            }
        }

        if (!$selectedObject) {
            if(!$returnUrlOfPage) //Si je veux l'objet mais que je trouve rien je retourne false
                return false;
            if ($returnAccueilIfNotFound) {
                return $this->generatePath("accueil");
            }

            $foundModule = $this->getModuleInfoFromModuleClass($classModule);
            if (!$foundModule) {
                if ($returnAccueilIfNotFound) {
                    return $this->generatePath("accueil");
                }
                return false;
            }

            return $this->generatePath("module_detail",array("idEncoded"=>$this->encodeId($this->getModuleInfoFromModuleClass($classModule)["classModule_front"])));
        }
        if ($returnUrlOfPage)
            return $this->generateUrlForRawObjet($objet);
        else
            return $objet;
    }

    public function getModuleInfoFromModuleClass($classModuleFront)
    {
        $em = $this->doctrine;
        $sql = "SELECT * from module_liste where module_liste.classModule_front = :classModuleFront ";

        $query = $em->getConnection()->prepare($sql);
        $query->execute(array(
            "classModuleFront" => $classModuleFront,
        ));

        if ($query->rowCount() == 0) {
            return false;
        }
        $infosModule = $query->fetchAll();

        return $infosModule;
    }

    public function getModuleInfoFromPageId($idPage){
        $em = $this->doctrine;

        $urlModule = $globalParams = $pageParams = "";

        $sql = "SELECT pages.page_params,module_liste.front_moduleClass,module_liste.param_module FROM pages JOIN module_liste ON pages.page_externe = module_liste.id_module WHERE pages.page_id = :idPage LIMIT 1";
        $query = $em->getConnection()->prepare($sql);
        $query->execute(array("idPage"=>$idPage));

        $infosModule = $query->fetchAll();
        if(isset($infosModule[0])){
            $urlModule = $infosModule[0]["front_moduleClass"];
            $globalParams = $infosModule[0]["param_module"];
            $pageParams = $infosModule[0]["page_params"];
        }
        return array($urlModule,$globalParams,$pageParams);
    }

    public function encodeId($id){
        return $this->hashids->encode($id);
    }
    public function decodeId($idEncoded){
        $tmp = $this->hashids->decode($idEncoded); //Retourne un tableau avec l'id dedans (ou un tableau vide)
        if(count($tmp)==0)
            return null;
        return $tmp[0];
    }
    public function generatePath($pathName,$parameters=array()){
        $parameters["lang"]=$this->getCurrentLangueShortCode();
        return $this->router->generate($pathName,$parameters);
    }

    // $forceObjectLang permet de forcer l'utilisation de la vraie langue de la page (utilisé pour siteMapXML)
    public function generateUrlForRawObjet(Array $objet, $forceObjectLang = false){
        //Création d'un objet avec le minimum pour que ça passe dans la fonction qui génére l'url
        $tmpObj = new Objets();
        $tmpObj->setObjId($objet["obj_id"]);
        $tmpObj->setObjTitre($objet["obj_titre"]);
        $tmpObj->setObjPere($objet["obj_pere"]);
        $tmpObj->setObjLang($objet["obj_lang"]);

        $tmpPage = new Pages();
        $tmpPage->setPageTitre($objet["page_titre"]);
        $tmpObj->setPage($tmpPage);
        return $this->generateUrlForObjet($tmpObj, $forceObjectLang);
    }

    public function getActuIsAgenda(){

        $em = $this->doctrine;
        $sql = 'SELECT actus.id_type_actu, actu_id, actu_image, actu_titre, actu_accroche, actu_date_deb_eve, actu_date_fin_eve FROM actus 
              join type_actu on actus.id_type_actu = type_actu.id_type_actu
              where type_actu.isAgenda = 1 ORDER BY actu_date_deb_eve';
//TODO gestion de la langue ??
        $query = $em->getConnection()->prepare($sql);
        $query->execute();
        $results = $query->fetchAll();

        return $results;
    }

    public function getAllInfoFichesHoraire(){
        $sqlLines = 'SELECT * FROM ficheshoraires_lignes WHERE actif =1 ORDER BY ordre ASC';
        $query = $this->doctrine->getConnection()->prepare($sqlLines);
        $query->execute();

        $lines = $query->fetchAll();

        $sqlCommunes = 'SELECT * FROM ficheshoraires_communes WHERE actif =1 ORDER BY nom_commune ASC';
        $query = $this->doctrine->getConnection()->prepare($sqlCommunes);
        $query->execute();

        $communes = $query->fetchAll();

        $sqlCategoriesTypesDifferents = 'SELECT DISTINCT id_categorie FROM ficheshoraires_lieux GROUP BY id_categorie';
        $query = $this->doctrine->getConnection()->prepare($sqlCategoriesTypesDifferents);
        $query->execute();

        $typesDifferents = $query->fetchAll();

        $sqlCategories = 'SELECT * FROM ficheshoraires_lieu_categories ORDER BY nom_categorie ASC';
        $query = $this->doctrine->getConnection()->prepare($sqlCategories);
        $query->execute();

        $categories = $query->fetchAll();

        $infosFichesHoraires = array(
            "lines"=>$lines,
            "communes"=>$communes,
            "typeDif"=>$typesDifferents,
            "categories"=>$categories
        );

        return $infosFichesHoraires;
    }

    public function getLieuFicheHoraireFromCatgeorie($idCategorie){
        $sqlLieu= 'SELECT * FROM ficheshoraires_lieux WHERE id_categorie =:idCategorie AND actif =1 ORDER BY nom_lieu ASC';
        $query = $this->doctrine->getConnection()->prepare($sqlLieu);
        $query->bindParam(":idCategorie",$idCategorie);
        $query->execute();

        $lieux = $query->fetchAll();

        return $lieux;
    }

    public function getPdf2MapInfoFromId($id){
        $em = $this->doctrine;
        $repositorySites = $em->getRepository('ActigraphActipageBaseBundle:Site');
        $site = $repositorySites->findOneBy(array());
        $domain = $site->getDomaine();


        $sql = 'SELECT * FROM module_carte WHERE carte_id = :carteId';
        $query = $this->doctrine->getConnection()->prepare($sql);
        $query->bindParam(":carteId",$id);
        $query->execute();
        $pdf2mapDb = $query->fetch();
        if(!$pdf2mapDb)
            return false;

        $sqlMarkers  = 'SELECT * FROM module_carte_marker WHERE carte_id = :carteId';
        $query = $this->doctrine->getConnection()->prepare($sqlMarkers);
        $query->bindParam(":carteId",$id);
        $query->execute();
        $pdf2mapMarkers = $query->fetchAll();
        $markers = array();

        $enableDownload = false;

        if($pdf2mapDb["bouton_telechargement"] == 1){
            $enableDownload = true;
        }
        if(count($pdf2mapMarkers)>0){
            foreach ($pdf2mapMarkers as $marker){
                $markers[]=array(
                    "marker_id"=>$marker["carte_marker_id"],
                    "lat"=>$marker["lat"],
                    "lng"=>$marker["lng"],
                    "nom"=>$marker["nom"],
                    "description"=>$marker["description"]
                );
            }
        }
        $httpClient = new Client(array(
            'timeout'  => 2.0
        ));
        try{
            $providerXmlInfo = $httpClient->get($pdf2mapDb["url_tiles"]."/ImageProperties.xml");
            $xmlRaw=$providerXmlInfo->getBody();
            $xml = new \SimpleXMLElement($xmlRaw);
            //dump($pdf2mapDb);
            return array(
                "tileWidth"=>$xml['WIDTH'],
                "tileHeight"=>$xml['HEIGHT'],
                "tileUrl"=>$pdf2mapDb["url_tiles"], //url_tiles
                "downloadLink"=>$domain."/upload/pdftomap/".$id."_plan.pdf", //$rw["domaine"]/upload/pdftomap/$carteID_plan.pdf
                "downloadLinkEnabled"=>$enableDownload, //bouton_telechargement
                "markers"=>$markers,
                "cssWidth"=>$pdf2mapDb["largeur_front"], //largeur_front
                "cssHeight"=>$pdf2mapDb["hauteur_front"] //hauteur_front
            );
        }catch (\Exception $e){
            return false;
        }

    }


    public function generateUrlForObjet(Objets $objet, $forcePageLang = false){
        /** @var Pages $page */
        $page = $objet->getPage();

        $em = $this->doctrine;


        if($objet->getObjTitre() == ""){
            //Recherche du titre dans le dossier parent
            $em = $this->doctrine;
            $sql = 'SELECT o.obj_titre FROM objets o LEFT JOIN pages p ON p.page_pere = o.obj_id WHERE o.obj_id = :objId';
            $query = $em->getConnection()->prepare($sql);
            $query->execute(array("objId"=>$objet->getObjPere()));
            $parentObj = $query->fetchAll();
            $urlTitle = $parentObj[0]["obj_titre"];
        }else{
            if($page && $page->getPageTitre() != "") //normalement ça ne doit pas arriver de ne pas avoir de titre
                $urlTitle = $page->getPageTitre();
            else
                $urlTitle=$objet->getObjTitre();
        }

        if($forcePageLang) {
            $repositoryLangues = $em->getRepository('ActigraphActipageBaseBundle:Langues');
            $languesPages = $repositoryLangues->findOneBy(array("langueId"=>$objet->getObjLang()));
            $lang = $languesPages->getLangueShortCode();
        } else {
            $lang = $this->getCurrentLangueShortCode();
        }

        return "/".$lang."/".$this->encodeId($objet->getObjId())."-".$this->no_accent($urlTitle).".html";
    }

    public function isClientAsOption($optionName){
        $config = $this->getSiteParams();
        if(isset($config[$optionName]))
            return $config[$optionName];
        return false;
    }

    public function getStyleSiteActive(){
        $em = $this->doctrine;
        $repository = $em->getRepository('ActigraphActipageBaseBundle:Styles');
        $styleActive = $repository->findOneBy(array("styleActive"=>1));

        return $styleActive;
    }

    public function getLangueTraduction(){
        $em = $this->doctrine;
        $repository = $em->getRepository('ActigraphActipageBaseBundle:Site');
        $site = $repository->findOneBy(array());
        $html = "";
        $currentLang = $this->getCurrentLangueShortCode();

        if($site->isTraductionPageSite()==1 && $site->getLangue() == 0){
            $html = '
            <div id="google_translate_element"></div>
            <script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                function googleTranslateElementInit() {
                    new google.translate.TranslateElement({
                        pageLanguage: \'fr\',
                        layout: google.translate.TranslateElement.InlineLayout.SIMPLE,
                        
                    },"google_translate_element");
                }
            </script><script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>';
        } else if($site->getLangue() == 1 && $site->isTraductionPageSite()==0) {
            if($this->session->get("isMobileLang",false)) {
                $queryBuilder = $this->doctrine->getRepository('ActigraphActipageBaseBundle:Langues')->createQueryBuilder('l')
                    ->where("l.langueShortCode like '%mobile-%'");
            } else {
                $queryBuilder = $this->doctrine->getRepository('ActigraphActipageBaseBundle:Langues')->createQueryBuilder('l')
                    ->where("l.langueShortCode not like '%mobile-%'");
            }

            $query = $queryBuilder->getQuery();
            $allLangue = $query->getResult();

            $html .= "<div class='col-md-6' id='bloc_langue'><span id='label_langue'></span>
                        <form name='form_langue' id='formulaire_langue'>
                            <label class='sr-only' for='Choix_Langue'>Traduction</label>  
                            <select id='Choix_Langue' name='Choix_Langue' class='form-control selectpicker'>";

            foreach ($allLangue as $langue){
                $selected = "";
                if($currentLang == $langue->getLangueShortCode())
                    $selected = "selected";
                $html .= "<option value='".$langue->getLangueShortCode()."' ".$selected.">".$langue->getLangueLib()."</option>";
            }

            $html .= "</select></form></div>";
        }

        return $html;

    }

    public function getTarteAuCitron()
    {
        $em = $this->doctrine;
        $repository = $em->getRepository('ActigraphActipageBaseBundle:Site');
        $site = $repository->findOneBy(array());
        $html = "";
        if (!isset($this->getSiteParams()["trackerEnabled"])) {
            return "";
        }
        if (isset($this->getSiteParams()["trackerTarteaucitronPro"]) && $this->getSiteParams()["trackerTarteaucitronPro"] != "") {
            return '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'" src="'.$this->getSiteParams()["trackerTarteaucitronPro"].'"></script>';
        }
        $trackerEnable = $this->getSiteParams()["trackerEnabled"];
        $highPrivacy = 'false';
        $bypass = 'true';

        if ($trackerEnable == true) {
            if($site->getCookieBandeau() == 1 && $site->getCookieBandeauBoutons() == 0) {
                $highPrivacy = 'false';
                $bypass = 'false';
            }else if($site->getCookieBandeau() == 1 && $site->getCookieBandeauBoutons() == 1) {
                $highPrivacy = 'true';
                $bypass = 'false';
            }else{
                $bypass = 'true';
            }
        }
//TODO voir pour inclure tarteaucitron dans SF et plus l'inclure en externe

        $privacyUrl = "";
        if (isset($this->getSiteParams()["tarteaucitronPolLink"])) {
            $privacyUrl = $this->getSiteParams()["tarteaucitronPolLink"];
        }

        if (isset($this->getSiteParams()["tarteaucitronVersion"])) {
            $tarteaucitronVersionOption = $this->getSiteParams()["tarteaucitronVersion"];
            $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'" src="https://cdn.actipage.net/tarteaucitron_'.$tarteaucitronVersionOption.'/tarteaucitron.js"></script>';
        } else {
            $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'" src="https://cdn.actipage.net/tarteaucitron_utf8/tarteaucitron.js"></script>';
        }

        if (isset($this->getSiteParams()["tarteaucitronVersion"])) {
            $tarteaucitronVersionOption = $this->getSiteParams()["tarteaucitronVersion"];
            $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                    tarteaucitron.init({

                          "privacyUrl": "'.$privacyUrl.'", /* Privacy policy url */
                          "bodyPosition": "top", /* or top to bring it as first element for accessibility */

                          "hashtag": "#tarteaucitron", /* Open the panel with this hashtag */
                          "cookieName": "tarteaucitron", /* Cookie name */
                    
                          "orientation": "bottom", /* Banner position (top - bottom) */
                       
                          "groupServices": false, /* Group services by category */
                          "serviceDefaultState": "wait", /* Default state (true - wait - false) */
                                           
                          "showAlertSmall": false, /* Show the small banner on bottom right */
                          "cookieslist": true, /* Show the cookie list */
                                           
                          "closePopup": false, /* Show a close X on the banner */

                          "showIcon": false, /* Show cookie icon to manage cookies */
                          //"iconSrc": "", /* Optionnal: URL or base64 encoded image */
                          "iconPosition": "BottomLeft", /* BottomRight, BottomLeft, TopRight and TopLeft */

                          "adblocker": false, /* Show a Warning if an adblocker is detected */
                                           
                          "DenyAllCta" : true, /* Show the deny all button */
                          "AcceptAllCta" : true, /* Show the accept all button when highPrivacy on */
                          "highPrivacy": '.$highPrivacy.', /* HIGHLY RECOMMANDED Disable auto consent */
                                           
                          "handleBrowserDNTRequest": false, /* If Do Not Track == 1, disallow all */

                          "removeCredit": true, /* Remove credit link */
                          "moreInfoLink": true, /* Show more info link */

                          "useExternalCss": false, /* If false, the tarteaucitron.css file will be loaded */
                          "useExternalJs": false, /* If false, the tarteaucitron.js file will be loaded */

                          //"cookieDomain": ".my-multisite-domaine.fr", /* Shared cookie for multisite */
                                          
                          "readmoreLink": "", /* Change the default readmore link */

                          "mandatory": true, /* Show a message about mandatory cookies */
                          "mandatoryCta": true /* Show the disabled accept button when mandatory on */

                        });
                    ';
        } else {
            $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                    tarteaucitron.init({
                            "privacyUrl": "'.$privacyUrl.'", /* Privacy policy url */
                            "mandatory": true,
                            "hashtag": "#tarteaucitron", /* Ouverture automatique du panel avec le hashtag */
                            "highPrivacy": '.$highPrivacy.', /* dÃ©sactiver le consentement implicite (en naviguant) ? */
                            "AcceptAllCta" : true,
                            "handleBrowserDNTRequest": false, /* If Do Not Track == 1, accept all */
                            "bodyPosition":"top", /* Premier-enfant du body pour une meilleure accessibilité */
                            "orientation": "bottom", /* le bandeau doit Ãªtre en haut (top) ou en bas (bottom) ? */
                            "adblocker": false, /* Afficher un message si un adblocker est dÃ©tectÃ© */
                            "showAlertSmall": false, /* afficher le petit bandeau en bas Ã  droite ? */
                            "cookieslist": true, /* Afficher la liste des cookies installÃ©s ? */
                            "removeCredit": true /* supprimer le lien vers la source ? */
                        });
                    ';
        }

        if ($bypass == 'true') {
            $html .= 'tarteaucitron.user.bypass = true;';
        }
        $html .= '</script>';

        if (isset($this->getSiteParams()["trackerOption"]))
            $trackerOption = $this->getSiteParams()["trackerOption"];
        else
            $trackerOption=[];
        if (is_array($trackerOption) && count($trackerOption)>0) {
            foreach ($trackerOption as $key => $value){
                if($key == "facebookpixel"){
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        tarteaucitron.user.'.$key.'Ua = "'.$value.'";
                        tarteaucitron.user.'.$key.'More = function () { 
                            _gaq.push (["_gat._anonymizeIp"]);
                        };
                        (tarteaucitron.job = tarteaucitron.job || []).push("'.$key.'");
                      </script>';
                } elseif ($key == "matomo") {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        tarteaucitron.user.'.$key.'Id = '.$value.';
                        (tarteaucitron.job = tarteaucitron.job || []).push("matomocloud");
                      </script>';
                } elseif ($key == "matomotransdev") {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        tarteaucitron.user.matomoId = "'.$value.'";
                        tarteaucitron.user.matomoHost = "https://transdevaurabfc.matomo.cloud/";
                        tarteaucitron.user.matomoCustomJSPath = "//cdn.matomo.cloud/transdevaurabfc.matomo.cloud/matomo.js";
                        (tarteaucitron.job = tarteaucitron.job || []).push("matomocloud");
                      </script>';
                } elseif ($key == "matomoHost") {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">tarteaucitron.user.matomoHost = "'.$value.'";</script>';
                } elseif ($key == "weborama") {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        (tarteaucitron.job = tarteaucitron.job || []).push("'.$key.'");
                      </script>';
                } elseif ($key == "googletagmanager") {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        tarteaucitron.user.googletagmanagerId = "'.$key.'";
                        (tarteaucitron.job = tarteaucitron.job || []).push("googletagmanager");
                      </script>';
                } elseif ($key == "piano") {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        tarteaucitron.user.pianoSite = "'.$value.'";
                        (tarteaucitron.job = tarteaucitron.job || []).push("pianoanalytics");
                      </script>';
                    if (isset($this->getSiteParams()['pianoDomain'])) {
                        $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                            tarteaucitron.user.pianoCollectDomain = "'.$this->getSiteParams()['pianoDomain'].'";tarteaucitron.user.pianoSendData = true;
                          </script>';
                    }
                } elseif ($key == 'youtube') {
                    $html .= '<script nonce="' . $this->contentSecurityPolicyNonceService->getNonce() . '">
                                document.addEventListener("DOMContentLoaded", function () {
                                    // Récupérer toutes les iframes
                                    const iframes = document.querySelectorAll("iframe[src*=\"youtube.com\"], iframe[src*=\"youtube-nocookie.com\"]");
                            
                                    iframes.forEach(iframe => {
                                        const videoID = new URL(iframe.src).pathname.split("/").pop();
                                        
                                        // Création d\'une div compatible avec Tarteaucitron
                                        const youtubeDiv = document.createElement("div");
                                        youtubeDiv.classList.add("youtube_player");
                                        youtubeDiv.setAttribute("videoID", videoID);
                                        youtubeDiv.setAttribute("width", iframe.getAttribute("width") || "560");
                                        youtubeDiv.setAttribute("height", iframe.getAttribute("height") || "315");
                                        youtubeDiv.setAttribute("autoplay", "0");
                                        youtubeDiv.setAttribute("mute", "0");
                                        youtubeDiv.setAttribute("loop", "0");
                            
                                        // Remplacement de l\'iframe par la div
                                        iframe.parentNode.replaceChild(youtubeDiv, iframe);
                                    });
                            
                                            // Ajout du service YouTube à tarteaucitron
                                            tarteaucitron.job = tarteaucitron.job || [];
                                            tarteaucitron.job.push("youtube");
                                        });
                                        </script>';
                    if ($this->getSiteParams()["tarteaucitron_youtube"] ?? false) {
                        $html .= '<script nonce="' . $this->contentSecurityPolicyNonceService->getNonce() . '">
                            (tarteaucitron.job = tarteaucitron.job || []).push("youtube");
                        </script>';
                    }

                } elseif ($key == 'actistat') {
                    $html .= '<script nonce="' . $this->contentSecurityPolicyNonceService->getNonce() . '">
                        tarteaucitron.services.actistat = {
                            "key": "actistat",
                            "type": "analytic",
                            "name": "ActiSTAT",
                            "uri": "https://actigraph.com/actistat",
                            "needConsent": false,
                            "cookies": [],
                            "js": function () {
                                "use strict";
                        
                                if (tarteaucitron.user.actistatId === undefined) {
                                    return;
                                }
                        
                                tarteaucitron.addScript(\'https://actistat.fr/umami.js\', \'\', \'\', \'\', \'data-website-id\', tarteaucitron.user.actistatId);
                            }
                        };
                        tarteaucitron.user.actistatId = "' . $value . '";
                        (tarteaucitron.job = tarteaucitron.job || []).push("actistat");
                      </script>
                      ';
                } elseif ($key == 'actistatv2') {
                    $domain = '';
                    $script = 'umami.js';
                    if (isset($this->getSiteParams()['actistatDomain'])) {
                        $domain = $this->getSiteParams()['actistatDomain'];
                        $domain .= '.';
                        $script = 'umami';
                    }
                    $domain .= 'actistat.fr';
                    $html .= '<script nonce="' . $this->contentSecurityPolicyNonceService->getNonce() . '">
                        tarteaucitron.services.actistatv2 = {
                            "key": "actistatv2",
                            "type": "analytic",
                            "name": "ActiSTAT",
                            "uri": "https://actigraph.com/actistat",
                            "needConsent": false,
                            "cookies": [],
                            "js": function () {
                                "use strict";
                        
                                if (tarteaucitron.user.actistatId === undefined) {
                                    return;
                                }
                        
                                tarteaucitron.addScript(\'https://'.$domain.'/'.$script.'\', \'\', \'\', \'\', \'data-website-id\', tarteaucitron.user.actistatId);
                            }
                        };
                        tarteaucitron.user.actistatId = "' . $value . '";
                        (tarteaucitron.job = tarteaucitron.job || []).push("actistatv2");
                      </script>
                      ';
                } elseif ($key == 'actistatdev') {
                    $html .= '<script nonce="' . $this->contentSecurityPolicyNonceService->getNonce() . '">
                        tarteaucitron.services.actistatdev = {
                            "key": "actistatdev",
                            "type": "analytic",
                            "name": "ActiSTAT DEV",
                            "uri": "https://actigraph.com/actistat",
                            "needConsent": false,
                            "cookies": [],
                            "js": function () {
                                "use strict";
                        
                                if (tarteaucitron.user.actistatdevId === undefined) {
                                    return;
                                }
                        
                                tarteaucitron.addScript(\'https://stats.actistat.fr/script.js\', \'\', \'\', \'\', \'data-website-id\', tarteaucitron.user.actistatdevId);
                            }
                        };
                        tarteaucitron.user.actistatdevId = "'.$value.'";
                        (tarteaucitron.job = tarteaucitron.job || []).push("actistatdev");
                      </script>
                      ';
                } elseif ($key == 'umamitadao') {
                    $html .= '<script nonce="' . $this->contentSecurityPolicyNonceService->getNonce() . '">
                        tarteaucitron.services.umamitadao = {
                            "key": "umamitadao",
                            "type": "analytic",
                            "name": "Umami TADAO",
                            "uri": "https://umami.is/",
                            "needConsent": false,
                            "cookies": [],
                            "js": function () {
                                "use strict";
                        
                                if (tarteaucitron.user.umamitadaoId === undefined) {
                                    return;
                                }
                        
                                tarteaucitron.addScript(\'https://analytics.tadao.fr/script.js\', \'\', \'\', \'\', \'data-website-id\', tarteaucitron.user.umamitadaoId);
                            }
                        };
                        tarteaucitron.user.umamitadaoId = "'.$value.'";
                        (tarteaucitron.job = tarteaucitron.job || []).push("umamitadao");
                      </script>
                      ';
                } else {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        tarteaucitron.user.'.$key.'Ua = "'.$value.'";
                        (tarteaucitron.job = tarteaucitron.job || []).push("'.$key.'");
                      </script>';
                }
                if (isset($this->getSiteParams()['captcha']['type']) && $this->getSiteParams()['captcha']['type'] == 'googlerecaptcha') {
                    $html .= '<script nonce="'.$this->contentSecurityPolicyNonceService->getNonce().'">
                        tarteaucitron.user.recaptchaapi = "'.$this->getSiteParams()['captcha']['config']['public'].'";
                        (tarteaucitron.job = tarteaucitron.job || []).push("recaptcha");
                      </script>';
                }
            }
        }

        // Système de monitoring Cognix cf. Ticket n° 6339-9274
        $html .= '<!-- CognixPattern = 7288edd0fc3ffcbe93a0cf06e3568e28521687bc -->';

        return $html;
    }

    public function getModuleRgpdInfo($classModuleFront) {
        $em = $this->doctrine;

        $sql = "SELECT asRgpd, labelContent, rgpdContent, showRgpd from module_liste where module_liste.classModule_front = :classModuleFront ";

        $query = $em->getConnection()->prepare($sql);
        $query->execute(array(
            "classModuleFront"=>$classModuleFront,
        ));

        if($query->rowCount() == 0){
            return false;
        }
        $infosModule = $query->fetchAll();
        return $infosModule[0];
    }

    /**
     * Fonction d'inscription aux alertes SMS gérées par Actipage
     * @param string $nom
     * @param string $prenom
     * @param string $telephone
     * @param array $lignesExternalCodes
     * @return boolean
     */
    public function inscriptionAlertSMS(string $nom,string $prenom,string $telephone,Array $lignesExternalCodes){
        $preuveSecretKey = "ITcGcd24o6Bgax3b6NH0NfhONVIzly4GvPuscESBycc=";
        $userIp = $this->requestStack->getCurrentRequest()->getClientIp();
        $tmp = explode(".",$userIp);
        array_pop($tmp);
        $userIp = implode(".",$tmp).".x";
        $userBrowser = $this->requestStack->getCurrentRequest()->headers->get('User-Agent');
        $timestamp = time();
        $preuveRaw = $userIp."|".$userBrowser."|".$timestamp."|".$telephone;
        $encryption_key = base64_decode($preuveSecretKey);
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
        $encrypted = openssl_encrypt($preuveRaw, 'aes-256-cbc', $encryption_key, 0, $iv);
        $encrypted = $encrypted . ':' . base64_encode($iv);
        $rgpd_preuve = "Actipage|".$timestamp."|".$encrypted;

        $this->desinscriptionAlertesSMS($telephone);
        if(count($lignesExternalCodes)==0)
            return false;
        $em = $this->doctrine;
        $emConnexion = $em->getConnection();
        $sql = "INSERT INTO sms_inscrits SET numero = :telephone, nom=:nom, prenom=:prenom, date_inscription=NOW(), rgpd_preuve=:rgpd_prevue";
        $query = $emConnexion->prepare($sql);
        $sqlAbonnement = "INSERT INTO sms_inscrits_lignes SET inscrit_id = :inscritId, LineExternalCode=:ligneExternalCode";
        $queryAbonnement = $emConnexion->prepare($sqlAbonnement);

        $query->execute(array(
            "telephone"=>$this->dataEncryptionService->encyptIfNeeded($telephone,FrontModules::MODULE_FORM_ALERTESSMS),
            "nom"=>$this->dataEncryptionService->encyptIfNeeded($nom,FrontModules::MODULE_FORM_ALERTESSMS),
            "prenom"=>$this->dataEncryptionService->encyptIfNeeded($prenom,FrontModules::MODULE_FORM_ALERTESSMS),
            "rgpd_prevue"=>$rgpd_preuve
        ));
        $inscritId = $emConnexion->lastInsertId();
        foreach($lignesExternalCodes as $ligneExternalCode){
            $queryAbonnement->execute(array(
                "inscritId"=>$inscritId,
                "ligneExternalCode"=>$ligneExternalCode,
            ));
        }
        return true;
    }

    public function desinscriptionAlertesSMS($telephone){
        $em = $this->doctrine;
        $emConnexion = $em->getConnection();

        $sqlDeleteInscrit = "DELETE FROM sms_inscrits WHERE id = :id";
        $queryDeleteInscrit = $emConnexion->prepare($sqlDeleteInscrit);
        $sqlDeleteInscritAbonnement = "DELETE FROM sms_inscrits_lignes WHERE inscrit_id = :id";
        $queryDeleteInscritAbonnement = $emConnexion->prepare($sqlDeleteInscritAbonnement);


        if($this->dataEncryptionService->isModuleDataEncryptNeeded(FrontModules::MODULE_FORM_ALERTESSMS)){
            $sql = "SELECT id,numero from sms_inscrits";
            $query = $emConnexion->prepare($sql);
            $query->execute();
            $InscritFoundIds = array();
            $telephoneintl = $this->formatPhoneNumberIntl($telephone);

            while ($existingInscritSMS = $query->fetch()){
                $telephoneInscritClear = $this->dataEncryptionService->decryptIfNeeded($existingInscritSMS["numero"],FrontModules::MODULE_FORM_ALERTESSMS);
                if($telephoneintl == $telephoneInscritClear || $telephone == $telephoneInscritClear)
                    $InscritFoundIds[] = $existingInscritSMS["id"];
            }
            if(count($InscritFoundIds) == 0)
                return true;
            foreach ($InscritFoundIds as $inscritFoundId){
                $queryDeleteInscritAbonnement->execute(array(
                    "id"=>$inscritFoundId,
                ));
                $queryDeleteInscrit->execute(array(
                    "id"=>$inscritFoundId,
                ));
            }

        }else{
            $sql = "SELECT id from sms_inscrits WHERE numero = :telephone OR numero = :telephoneintl";
            $query = $emConnexion->prepare($sql);


            $query->execute(array(
                "telephone"=>$telephone,
                "telephoneintl"=>$this->formatPhoneNumberIntl($telephone)
            ));
            if($query->rowCount() == 0){
                return false;
            }
            $inscriptionsSMS = $query->fetchAll();
            foreach($inscriptionsSMS as $inscriptionSMS){
                $queryDeleteInscritAbonnement->execute(array(
                    "id"=>$inscriptionSMS["id"],
                ));
                $queryDeleteInscrit->execute(array(
                    "id"=>$inscriptionSMS["id"],
                ));
            }
        }


        return true;
    }

    public function formatPhoneNumberIntl($number){

    }

    public function getProchainsPassagesTimeoLignes($idReseau,$token){
        $urlApi = "http://timeo.keolis.com/pivk/?service=api&ville=".$idReseau."&key=".$token."&xml=1&rand=".rand(0, 1000000000);
        $httpClient = new Client(array(
            'timeout'  => 2.0
        ));
        $lignes=[];
        try{
            $timeoApiResponse = $httpClient->get($urlApi);
            $xmlRaw=$timeoApiResponse->getBody();

            //Test permet d'avoir des données sans avoir l'ip autorisé
            /* $xmlRaw = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>
 <xmldata>
   <erreur code=\"000\"></erreur>

   <heure>10:54</heure>
   <date>2019-05-02</date>

   <expire>69660</expire>

   <alss nb=\"32\">
     <als id=\"1\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>1</code>
         <nom>1</nom>
         <sens>A</sens>
         <vers>Lycée en Fôret, Hôpital</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"2\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>1</code>
         <nom>1</nom>
         <sens>R</sens>
         <vers>Bûges, Blaise</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"3\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>2</code>
         <nom>2</nom>
         <sens>A</sens>
         <vers>Antibes, St Firmin</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"4\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>2</code>
         <nom>2</nom>
         <sens>R</sens>
         <vers>Lancy, Cepoy</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"5\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>3</code>
         <nom>3</nom>
         <sens>A</sens>
         <vers>Amilly Centre, ZI Amilly, Clériceau</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"6\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>3</code>
         <nom>3</nom>
         <sens>R</sens>
         <vers>Eluard, Ste Catherine</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"7\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>4</code>
         <nom>4</nom>
         <sens>A</sens>
         <vers>St Nicolas</vers>
         <couleur>65535</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"8\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>4</code>
         <nom>4</nom>
         <sens>R</sens>
         <vers>Mermoz, Les Ponets</vers>
         <couleur>65535</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"9\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>11</code>
         <nom>11</nom>
         <sens>A</sens>
         <vers>Lycée en Forêt Arrière</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"10\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>11</code>
         <nom>11</nom>
         <sens>R</sens>
         <vers>Jaugène</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"11\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>12</code>
         <nom>12</nom>
         <sens>A</sens>
         <vers>Lycée en Forêt Devant</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"12\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>12</code>
         <nom>12</nom>
         <sens>R</sens>
         <vers>Sauvageon</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"13\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>13</code>
         <nom>13</nom>
         <sens>A</sens>
         <vers>Verdier</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"14\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>13</code>
         <nom>13</nom>
         <sens>R</sens>
         <vers>Grotte aux loups</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"15\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>21</code>
         <nom>21</nom>
         <sens>A</sens>
         <vers>Lycée en Forêt Arrière</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"16\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>21</code>
         <nom>21</nom>
         <sens>R</sens>
         <vers>Grimbonnerie</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"17\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>22</code>
         <nom>22</nom>
         <sens>A</sens>
         <vers>Collège Grand Clos</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"18\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>22</code>
         <nom>22</nom>
         <sens>R</sens>
         <vers>Grotte aux loups</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"19\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>23</code>
         <nom>23</nom>
         <sens>A</sens>
         <vers>Lycée en Fôret Arrière</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"20\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>23</code>
         <nom>23</nom>
         <sens>R</sens>
         <vers>Clériceau</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"21\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>24</code>
         <nom>24</nom>
         <sens>A</sens>
         <vers>Lycée en Fôret Arrière</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"22\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>24</code>
         <nom>24</nom>
         <sens>R</sens>
         <vers>Gros Moulin</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"23\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>31</code>
         <nom>31</nom>
         <sens>A</sens>
         <vers>Collège Lucie Aubrac</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"24\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>31</code>
         <nom>31</nom>
         <sens>R</sens>
         <vers>Plateau</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"25\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>32</code>
         <nom>32</nom>
         <sens>A</sens>
         <vers>Collège Eluard</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"26\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>32</code>
         <nom>32</nom>
         <sens>R</sens>
         <vers>Hutchinson</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"27\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>33</code>
         <nom>33</nom>
         <sens>A</sens>
         <vers>Collège Picasso</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"28\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>33</code>
         <nom>33</nom>
         <sens>R</sens>
         <vers>Blaise</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"29\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>34</code>
         <nom>34</nom>
         <sens>A</sens>
         <vers>Collège Schuman</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"30\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>34</code>
         <nom>34</nom>
         <sens>R</sens>
         <vers>Gudin</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"31\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>51</code>
         <nom>51</nom>
         <sens>A</sens>
         <vers>Collège Schuman</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
     <als id=\"32\">
       <arret>
         <code></code>
         <nom></nom>
       </arret>
       <ligne>
         <code>51</code>
         <nom>51</nom>
         <sens>R</sens>
         <vers>Prieuré</vers>
         <couleur>0</couleur>
       </ligne>
       <refs></refs>
     </als>
   </alss>

 </xmldata>";*/
            $xml = new \SimpleXMLElement($xmlRaw);

            if(isset($xml->alss)&& isset($xml->alss->als) && count($xml->alss->als)>0){
                foreach($xml->alss->als as $als){
                    $ligne = $als->ligne;
                    $lignes[]=array("id"=>$ligne->code."_".$ligne->sens,"nom"=>$ligne->nom." > ".$ligne->vers);
                }
            }
        }catch (\Exception $e){
            return [];
        }
        return $lignes;
    }

    public function getClientInfos()
    {
        $em = $this->doctrine;
        $repositorySites = $em->getRepository('ActigraphActipageBaseBundle:Site');
        $site = $repositorySites->findOneBy(array());
        return $site;
    }

    public function getPageAccueilInfos()
    {
        $em = $this->doctrine;
        $repositoryAccueil = $em->getRepository('ActigraphActipageBaseBundle:Accueil');
        $accueil = $repositoryAccueil->findOneBy(array("accueilLang"=>$this->getCurrentLangueId()));
        return $accueil;
    }

    private function no_accent($str_accent)
    {
        $pattern = Array("/é/", "/è/", "/ê/", "/ç/", "/à/", "/â/", "/î/", "/ï/", "/ù/", "/ô/" , "/ /", "/'/");
        // notez bien les / avant et après les caractères
        $rep_pat = Array("e", "e", "e", "c", "a", "a", "i", "i", "u", "o","-","-");
        $str_noacc = preg_replace($pattern, $rep_pat, $str_accent);
        $str_noacc = urlencode($str_noacc);
        $str_noacc = str_replace("%","",$str_noacc);
        return urlencode($str_noacc);
    }
}
