<?php
namespace Actigraph\ActipageBaseBundle\EventListener;

use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Created by IntelliJ IDEA.
 * User: damien
 * Date: 13/02/2017
 * Time: 20:31
 */
class LocaleListener
{
    private $defaultLangue;

    public function __construct($locale)
    {
        $this->defaultLangue = $locale;
    }

    public function onKernelRequest(GetResponseEvent $event)
    {
        $request = $event->getRequest();
        $pathArray =  explode("/",$request->getPathInfo());
        $isMobileLang=false;

        if(strlen($pathArray[1]) == 0){
            //Pas de langue dans l'url donc detection de la langue que l'utilisateur préfére dans nos langues
            $locale = substr($request->getPreferredLanguage(array()), 0, 2);
            if($locale == "") //Si pas de langue dans les headers du navigateur alors on prend français
                $locale ="fr";
            $requestedLang=$locale;

        }else{
            $langExplode = explode("-",$pathArray[1]);
            if(count($langExplode)==1)
                $requestedLang = $langExplode[0]; // Cas url /fr/XXXX
            else{ // Cas url /mobile-fr/XXXXX
                $requestedLang = $langExplode[1];
                if($langExplode[0] == "mobile")
                    $isMobileLang=true;
            }
            $locale = $requestedLang;
        }

        $session =  $request->getSession();
        $session->set('requestedLang', $requestedLang);//Indique si c'est une langue mobile ou non (utile pour la recherche)
        $session->set('isMobileLang', $isMobileLang);//Indique si c'est une langue mobile ou non (utile pour la recherche)
        $request->setLocale($locale);
    }

}
