<?php
/**
 * Created by PhpStorm.
 * User: Imac
 * Date: 15/01/2019
 * Time: 12:09
 */

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;


/**
 * TitreTarif
 *
 * @ORM\Table(name="titre_tarif", indexes={@ORM\Index(name="id_titre", columns={"id_titre"})})
 * @ORM\Entity
 *
 */
class TitreTarif
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id_titre_tarif", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idTitreTarif;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_titre", type="integer", nullable=false)
     */
    private $idTitre;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_titre_tarif", type="date", nullable=false)
     */
    private $dateTitreTarif;

    /**
     * @var string
     *
     * @ORM\Column(name="prix_titre", type="decimal", precision=10, scale=2, nullable=false)
     */
    private $prixTitre;



    /**
     * @var integer
     *
     * @ORM\Column(name="prix_valide", type="integer", nullable=false)
     */
    private $prixValide;

    /**
     * @return int
     */
    public function getIdTitreTarif()
    {
        return $this->idTitreTarif;
    }

    /**
     * @param int $idTitreTarif
     */
    public function setIdTitreTarif($idTitreTarif)
    {
        $this->idTitreTarif = $idTitreTarif;
    }

    /**
     * @return int
     */
    public function getIdTitre()
    {
        return $this->idTitre;
    }

    /**
     * @param int $idTitre
     */
    public function setIdTitre($idTitre)
    {
        $this->idTitre = $idTitre;
    }

    /**
     * @return \DateTime
     */
    public function getDateTitreTarif()
    {
        return $this->dateTitreTarif;
    }

    /**
     * @param \DateTime $dateTitreTarif
     */
    public function setDateTitreTarif($dateTitreTarif)
    {
        $this->dateTitreTarif = $dateTitreTarif;
    }

    /**
     * @return string
     */
    public function getPrixTitre()
    {
        return $this->prixTitre;
    }

    /**
     * @param string $prixTitre
     */
    public function setPrixTitre($prixTitre)
    {
        $this->prixTitre = $prixTitre;
    }

    /**
     * @return int
     */
    public function getPrixValide()
    {
        return $this->prixValide;
    }

    /**
     * @param int $prixValide
     */
    public function setPrixValide($prixValide)
    {
        $this->prixValide = $prixValide;
    }

}