<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ParticipantJeux
 *
 * @ORM\Table(name="participant_jeux")
 * @ORM\Entity
 */
class ParticipantJeux
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id_participant", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idParticipant;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_jeu", type="integer", nullable=false)
     */
    private $idJeu;

    /**
     * @var string
     *
     * @ORM\Column(name="civilite", type="string", length=10, nullable=false)
     */
    private $civilite;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=100, nullable=false)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="prenom", type="string", length=100, nullable=false)
     */
    private $prenom;

    /**
     * @var string
     *
     * @ORM\Column(name="adresse", type="string", length=100, nullable=false)
     */
    private $adresse;

    /**
     * @var string
     *
     * @ORM\Column(name="cp", type="string", length=10, nullable=false)
     */
    private $cp;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=100, nullable=false)
     */
    private $ville;

    /**
     * @var string
     *
     * @ORM\Column(name="mail", type="string", length=100, nullable=false)
     */
    private $mail;

    /**
     * @var string
     *
     * @ORM\Column(name="tel", type="string", length=50, nullable=false)
     */
    private $tel;

    /**
     * @var string
     *
     * @ORM\Column(name="code_reponse", type="string", length=20, nullable=false)
     */
    private $codeReponse;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_participation", type="datetime", nullable=false)
     */
    private $dateParticipation;


    /**
     * @var string
     *
     * @ORM\Column(name="complement", type="string", length=255, nullable=false)
     */
    private $complement;

    /**
     * @return int
     */
    public function getIdParticipant(): int
    {
        return $this->idParticipant;
    }


    /**
     * @param int $idParticipant
     */
    public function setIdParticipant(int $idParticipant)
    {
        $this->idParticipant = $idParticipant;
    }

    /**
     * @return int
     */
    public function getIdJeu(): int
    {
        return $this->idJeu;
    }

    /**
     * @param int $idJeu
     */
    public function setIdJeu(int $idJeu)
    {
        $this->idJeu = $idJeu;
    }

    /**
     * @return string
     */
    public function getCivilite(): string
    {
        return $this->civilite;
    }

    /**
     * @param string $civilite
     */
    public function setCivilite(string $civilite)
    {
        $this->civilite = $civilite;
    }

    /**
     * @return string
     */
    public function getNom(): string
    {
        return $this->nom;
    }

    /**
     * @param string $nom
     */
    public function setNom(string $nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return string
     */
    public function getPrenom(): string
    {
        return $this->prenom;
    }

    /**
     * @param string $prenom
     */
    public function setPrenom(string $prenom)
    {
        $this->prenom = $prenom;
    }

    /**
     * @return string
     */
    public function getAdresse(): string
    {
        return $this->adresse;
    }

    /**
     * @param string $adresse
     */
    public function setAdresse(string $adresse)
    {
        $this->adresse = $adresse;
    }

    /**
     * @return string
     */
    public function getCp(): string
    {
        return $this->cp;
    }

    /**
     * @param string $cp
     */
    public function setCp(string $cp)
    {
        $this->cp = $cp;
    }

    /**
     * @return string
     */
    public function getVille(): string
    {
        return $this->ville;
    }

    /**
     * @param string $ville
     */
    public function setVille(string $ville)
    {
        $this->ville = $ville;
    }

    /**
     * @return string
     */
    public function getMail(): string
    {
        return $this->mail;
    }

    /**
     * @param string $mail
     */
    public function setMail(string $mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return string
     */
    public function getTel(): string
    {
        return $this->tel;
    }

    /**
     * @param string $tel
     */
    public function setTel(string $tel)
    {
        $this->tel = $tel;
    }

    /**
     * @return string
     */
    public function getCodeReponse(): string
    {
        return $this->codeReponse;
    }

    /**
     * @param string $codeReponse
     */
    public function setCodeReponse(string $codeReponse)
    {
        $this->codeReponse = $codeReponse;
    }

    /**
     * @return \DateTime
     */
    public function getDateParticipation(): \DateTime
    {
        return $this->dateParticipation;
    }

    /**
     * @param \DateTime $dateParticipation
     */
    public function setDateParticipation(\DateTime $dateParticipation)
    {
        $this->dateParticipation = $dateParticipation;
    }

    /**
     * @return string
     */
    public function getComplement(): string
    {
        return $this->complement;
    }

    /**
     * @param string $complement
     */
    public function setComplement(string $complement)
    {
        $this->complement = $complement;
    }



}
