<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Objets
 *
 * @ORM\Table(name="objets")
 * @ORM\Entity
 */
class Objets
{
    /**
     * @var integer
     *
     * @ORM\Column(name="obj_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $objId;


    /**
     * @ORM\OneToOne(targetEntity="Pages", mappedBy="objet", cascade={"remove","persist"}, fetch="EAGER")
     */
    private $page;

    /**
     * @return mixed
     */
    public function getPage()
    {
        return $this->page;
    }

    /**
     * @param mixed $page
     */
    public function setPage($page)
    {
        $this->page = $page;
    }

    /**
     * @var string
     * @Assert\NotBlank(message="Vous devez définir un titre Objet")
     * @ORM\Column(name="obj_titre", type="string", length=50, nullable=false)
     */
    private $objTitre = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="obj_ordre", type="integer", nullable=false)
     */
    private $objOrdre = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="obj_pere", type="integer", nullable=false)
     */
    private $objPere = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="obj_page", type="integer", nullable=false)
     */
    private $objPage = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="obj_visu", type="integer", nullable=false)
     */
    private $objVisu = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="obj_lang", type="integer", nullable=false)
     */
    private $objLang = '1';

    /**
     * @var string
     *
     * @ORM\Column(name="obj_class", type="string", length=255, nullable=false)
     */
    private $objClass;
    
    /**
     * @ORM\OneToOne(targetEntity="ObjetsCustomPageClass")
     * @ORM\JoinColumn(name="obj_custompageclass_id", referencedColumnName="id")
     */
    private $objCustompageClass;

    /**
     * @var string
     *
     * @ORM\Column(name="permalien", type="string", length=255, nullable=false)
     */
    private $permalien;
    /**
     * @return string
     */
    public function getObjClass()
    {
        return $this->objClass;
    }

    /**
     * @param string $objClass
     */
    public function setObjClass($objClass)
    {
        $this->objClass = $objClass;
    }

    /**
     * @return int
     */
    public function getObjId()
    {
        return $this->objId;
    }

    /**
     * @param int $objId
     */
    public function setObjId($objId)
    {
        $this->objId = $objId;
    }

    /**
     * @return int
     */
    public function getObjLang()
    {
        return $this->objLang;
    }

    /**
     * @param int $objLang
     */
    public function setObjLang($objLang)
    {
        $this->objLang = $objLang;
    }

    /**
     * @return int
     */
    public function getObjOrdre()
    {
        return $this->objOrdre;
    }

    /**
     * @param int $objOrdre
     */
    public function setObjOrdre($objOrdre)
    {
        $this->objOrdre = $objOrdre;
    }

    /**
     * @return int
     */
    public function getObjPage()
    {
        return $this->objPage;
    }

    /**
     * @param int $objPage
     */
    public function setObjPage($objPage)
    {
        $this->objPage = $objPage;
    }

    /**
     * @return int
     */
    public function getObjPere()
    {
        return $this->objPere;
    }

    /**
     * @param int $objPere
     */
    public function setObjPere($objPere)
    {
        $this->objPere = $objPere;
    }

    /**
     * @return string
     */
    public function getObjTitre()
    {
        return $this->objTitre;
    }

    /**
     * @param string $objTitre
     */
    public function setObjTitre($objTitre)
    {
        $this->objTitre = $objTitre;
    }

    /**
     * @return int
     */
    public function getObjVisu()
    {
        return $this->objVisu;
    }

    /**
     * @param int $objVisu
     */
    public function setObjVisu($objVisu)
    {
        $this->objVisu = $objVisu;
    }

    /**
     * @return string
     */
    public function getPermalien()
    {
        return $this->permalien;
    }

    /**
     * @param string $permalien
     */
    public function setPermalien($permalien)
    {
        $this->permalien = $permalien;
    }
    /**
     * @return mixed
     */
    public function getObjCustompageClass()
    {
        return $this->objCustompageClass;
    }

    /**
     * @param mixed $objCustompageClass
     */
    public function setObjCustompageClass($objCustompageClass): void
    {
        $this->objCustompageClass = $objCustompageClass;
    }
}
