<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="miniatures")
 * @ORM\Entity
 */
class Miniature
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="image_miniature", type="string", length=200, nullable=false)
     */
    private $imageMiniature;


    /**
     * @var string
     *
     * @ORM\Column(name="id_page", type="string", length=200, nullable=false)
     */
    private $idPage;


    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getIdPage(): string
    {
        return $this->idPage;
    }

    /**
     * @return string
     */
    public function getImageMiniature(): string
    {
        return $this->imageMiniature;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @param string $idPage
     */
    public function setIdPage(string $idPage): void
    {
        $this->idPage = $idPage;
    }

    /**
     * @param string $imageMiniature
     */
    public function setImageMiniature(string $imageMiniature): void
    {
        $this->imageMiniature = $imageMiniature;
    }


}