<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Lignes
 *
 * @ORM\Table(name="lignes")
 * @ORM\Entity
 */
class Lignes
{
    /**
     * @var string
     *
     * @ORM\Column(name="LineExternalCode", type="string", length=20, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $lineexternalcode;
    /**
     * @var string
     *
     * @ORM\Column(name="LineName", type="string", length=100, nullable=false)
     */
    private $linename;

    /**
     * @var string
     *
     * @ORM\Column(name="Linecode", type="string", length=20, nullable=false)
     */
    private $linecode;

    /**
     * @var integer
     *
     * @ORM\Column(name="ordre", type="integer", nullable=false)
     */
    private $ordre;

    /**
     * @var integer
     *
     * @ORM\Column(name="affiche", type="integer", nullable=false)
     */
    private $affiche = '1';

    /**
     * @ORM\ManyToMany(targetEntity="Actigraph\ActipageBaseBundle\Entity\Actus", inversedBy="lignes")
     * @ORM\JoinTable(
     *     name="actus_lignes",
     *     joinColumns={@ORM\JoinColumn(name="LineExternalCode", referencedColumnName="LineExternalCode")},
     *     inverseJoinColumns={@ORM\JoinColumn(name="actu_id", referencedColumnName="actu_id")}
     * )
     */
    private $actus;

    /**
     * @return string
     */
    public function getLineexternalcode()
    {
        return $this->lineexternalcode;
    }

    /**
     * @param string $lineexternalcode
     */
    public function setLineexternalcode($lineexternalcode)
    {
        $this->lineexternalcode = $lineexternalcode;
    }

    /**
     * @return string
     */
    public function getLinename()
    {
        return $this->linename;
    }

    /**
     * @param string $linename
     */
    public function setLinename($linename)
    {
        $this->linename = $linename;
    }

    /**
     * @return string
     */
    public function getLinecode()
    {
        return $this->linecode;
    }

    /**
     * @param string $linecode
     */
    public function setLinecode($linecode)
    {
        $this->linecode = $linecode;
    }

    /**
     * @return int
     */
    public function getOrdre()
    {
        return $this->ordre;
    }

    /**
     * @param int $ordre
     */
    public function setOrdre($ordre)
    {
        $this->ordre = $ordre;
    }

    /**
     * @return int
     */
    public function getAffiche()
    {
        return $this->affiche;
    }

    /**
     * @param int $affiche
     */
    public function setAffiche($affiche)
    {
        $this->affiche = $affiche;
    }

    public function getActus()
    {
        return $this->actus;
    }

    public function setActus($actus): self
    {
        $this->actus = $actus;

        return $this;
    }
}
