<?php

namespace Actigraph\ActipageBaseBundle\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="infocomplementaire")
 * @ORM\Entity
 */
class InfosComplementaires
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="informations", type="string", length=200, nullable=false)
     */
    private $informations;

    /**
     * @var string
     *
     * @ORM\Column(name="id_page", type="string", length=200, nullable=false)
     */
    private $idPage;


    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getInformations(): string
    {
        return $this->informations;
    }

    /**
     * @return string
     */
    public function getIdPage(): string
    {
        return $this->idPage;
    }

    /**
     * @param string $idPage
     */
    public function setIdPage(string $idPage): void
    {
        $this->idPage = $idPage;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @param string $informations
     */
    public function setInformations(string $informations): void
    {
        $this->informations = $informations;
    }


}