<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Actigraph\ActipageBaseBundle\Repository\FormuleRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=FormuleRepository::class)
 */
class Formule implements \JsonSerializable
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue
     */
    private $id;

    /**
     * @ORM\Column(type="string", nullable=false, length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="string", nullable=true, length=255)
     */
    private $description;

    /**
     * @ORM\Column(type="float", nullable=false)
     */
    private $price;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $nextPrice;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $nextPriceAt;

    /**
     * @ORM\Column(type="array", nullable=true)
     */
    private $pointsOfSales;

    /**
     * @ORM\Column(type="string", nullable=false, length=255)
     */
    private $url;

    /**
     * @ORM\Column(type="string", nullable=false, length=255)
     */
    private $type;

    /**
     * @ORM\ManyToMany(targetEntity="FormuleItem", inversedBy="formules", cascade={"persist"})
     * @ORM\JoinTable(name="formule_relation")
     */
    private $items;

    /**
     * @ORM\Column(name="f_order", type="integer", nullable=false)
     */
    private $order;

    /**
     * @ORM\Column(type="json", nullable=true)
     */
    private $options;

    /**
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $createdAt;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $updatedAt;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $updatedBy;

    public function __construct()
    {
        $this->setCreatedAt(new \DateTime());
        $this->setPointsOfSales([]);
        $this->setName('Nouveau tarif');
        $this->setDescription('Description du tarif');
        $this->setPrice(0.00);
        $this->setUrl('https://');
        $this->setType('Ticket');
        $this->items = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId(?int $id)
    {
        $this->id = $id;

        return $this;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function setDescription($description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getPrice()
    {
        return $this->price;
    }

    public function setPrice($price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getUrl()
    {
        return $this->url;
    }

    public function setUrl($url): self
    {
        $this->url = $url;

        return $this;
    }

    public function getNextPrice()
    {
        return $this->nextPrice;
    }

    public function setNextPrice($nextPrice): self
    {
        $this->nextPrice = $nextPrice;

        return $this;
    }

    public function getNextPriceAt(): ?\DateTime
    {
        return $this->nextPriceAt;
    }

    public function setNextPriceAt($nextPriceAt): self
    {
        $this->nextPriceAt = $nextPriceAt;

        return $this;
    }

    public function getPointsOfSales()
    {
        return $this->pointsOfSales;
    }

    public function setPointsOfSales($pointsOfSales): self
    {
        $this->pointsOfSales = $pointsOfSales;

        return $this;
    }

    public function getType()
    {
        return $this->type;
    }

    public function setType($type): self
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @return Collection|FormuleItem[]
     */
    public function getItems(): Collection
    {
        return $this->items;
    }

    public function addItem(FormuleItem $item): self
    {
        if (!$this->items->contains($item)) {
            $this->items[] = $item;
        }
        return $this;
    }

    public function removeItem(FormuleItem $item): self
    {
        $this->items->removeElement($item);

        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder(int $order): self
    {
        $this->order = $order;

        return $this;
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function setOptions($options)
    {
        return $this->options = $options;
    }

    public function addOption($name, $value): self
    {
        $options = $this->getOptions();
        $options[$name] = $value;

        $this->setOptions($options);

        return $this;
    }

    public function getOption($option, $returnValue=null)
    {
        return $this->options[$option] ?? $returnValue;
    }

    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    public function setCreatedAt($createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
    public function setUpdatedAt($updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getUpdatedBy()
    {
        return $this->updatedBy;
    }

    public function setUpdatedBy($updatedBy): self
    {
        $this->updatedBy = $updatedBy;

        return $this;
    }

    public function jsonSerialize()
    {
        return [
            'id' => $this->getId(),
            'order' => $this->getOrder(),
        ];
    }
}
