<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Accueil
 *
 * @ORM\Table(name="accueil", indexes={@ORM\Index(name="accueil_desc", columns={"accueil_desc"}), @ORM\Index(name="accueil_mot", columns={"accueil_mot"}), @ORM\Index(name="accueil_titre", columns={"accueil_titre"})})
 * @ORM\Entity
 */
class Accueil
{
    /**
     * @var integer
     *
     * @ORM\Column(name="accueil_lang", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $accueilLang = '1';

    /**
     * @var string
     *
     * @ORM\Column(name="accueil_titre", type="string", length=255, nullable=true)
     */
    private $accueilTitre;

    /**
     * @var string
     *
     * @ORM\Column(name="accueil_desc", type="string", length=255, nullable=true)
     */
    private $accueilDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="accueil_mot", type="string", length=255, nullable=true)
     */
    private $accueilMot;

    /**
     * @var string
     *
     * @ORM\Column(name="accueil_text", type="text", nullable=true)
     */
    private $accueilText;

    /**
     * @var string
     *
     * @ORM\Column(name="accueil_mentions", type="text", nullable=true)
     */
    private $accueilMentions;

    /**
     * @var string
     *
     * @ORM\Column(name="accueil_regles", type="text", nullable=false)
     */
    private $accueilRegles;

    /**
     * @return int
     */
    public function getAccueilLang()
    {
        return $this->accueilLang;
    }

    /**
     * @param int $accueilLang
     */
    public function setAccueilLang($accueilLang)
    {
        $this->accueilLang = $accueilLang;
    }

    /**
     * @return string
     */
    public function getAccueilTitre()
    {
        return $this->accueilTitre;
    }

    /**
     * @param string $accueilTitre
     */
    public function setAccueilTitre($accueilTitre)
    {
        $this->accueilTitre = $accueilTitre;
    }

    /**
     * @return string
     */
    public function getAccueilDesc()
    {
        return $this->accueilDesc;
    }

    /**
     * @param string $accueilDesc
     */
    public function setAccueilDesc($accueilDesc)
    {
        $this->accueilDesc = $accueilDesc;
    }

    /**
     * @return string
     */
    public function getAccueilMot()
    {
        return $this->accueilMot;
    }

    /**
     * @param string $accueilMot
     */
    public function setAccueilMot($accueilMot)
    {
        $this->accueilMot = $accueilMot;
    }

    /**
     * @return string
     */
    public function getAccueilText()
    {
        return $this->accueilText;
    }

    /**
     * @param string $accueilText
     */
    public function setAccueilText($accueilText)
    {
        $this->accueilText = $accueilText;
    }

    /**
     * @return string
     */
    public function getAccueilMentions()
    {
        return $this->accueilMentions;
    }

    /**
     * @param string $accueilMentions
     */
    public function setAccueilMentions($accueilMentions)
    {
        $this->accueilMentions = $accueilMentions;
    }

    /**
     * @return string
     */
    public function getAccueilRegles()
    {
        return $this->accueilRegles;
    }

    /**
     * @param string $accueilRegles
     */
    public function setAccueilRegles($accueilRegles)
    {
        $this->accueilRegles = $accueilRegles;
    }


}
