<?php
/**
 * Created by IntelliJ IDEA.
 * User: damien
 * Date: 17/06/2017
 * Time: 18:48
 */

namespace Actigraph\ActipageBaseBundle\Controller;

use Actigraph\ActipageBaseBundle\Services\ActipageService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class ActipageBaseController extends AbstractController
{
    protected function handleLangueParam(ActipageService $actipageService, $failBackLang = false){
        $langueIsValid = $actipageService->checkLangueInfo($failBackLang);
        if(!$langueIsValid)
            throw new NotFoundHttpException("La langue n'existe pas");
    }

    protected function extendAndRender($twigFile,$twigParams,$extendMethode,$extendMethodeParams=array(),ActipageService $actipageService){

        $extendResponse = $actipageService->handleExtend($extendMethode,$extendMethodeParams);
        if($extendResponse != false){
            if(isset($extendResponse["redirect"]))
                return $this->redirect($extendResponse["redirect"]);
            if(isset($extendResponse["twigParams"]))
                $twigParams = array_merge($twigParams,$extendResponse["twigParams"]);
            if(isset($extendResponse["twigFile"]))
                $twigFile = $extendResponse["twigFile"];
        }

        return $this->render($twigFile, $twigParams);
    }

    protected function checkIfMaintenance(ActipageService $actipageService){
        if($actipageService->getCurrentMaintenance() != false)
            return true;
        return false;
    }
}
