const util = require("./util");

if($("#moduleContactSubmit").length>0) {
    $("#moduleContactSubmit").on("click", function (e) {
        e.preventDefault()
        var erreur = [];
        var formValid = true;
        let alreadyFocused=false;

        if($("#theme").length == 1){
            if(document.moduleFormContact.theme.value==="-1"){
                erreur.push("Vous devez sélectionner un thème");
                if(!alreadyFocused){
                    $("#theme").focus();
                    alreadyFocused=true;
                }
                formValid = false;
            }
        }
        if(document.moduleFormContact.message.value===""){
            erreur.push("Vous devez préciser un message");
             if(!alreadyFocused){
                    $("#message").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.moduleFormContact.nom.value===""){
            erreur.push("Vous devez préciser votre nom de famille");
             if(!alreadyFocused){
                    $("#nom").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        }
        if(document.moduleFormContact.mail.value===""){
            erreur.push("Vous devez préciser votre e-mail (format attendu : nomprenom@mail.com)");
             if(!alreadyFocused){
                    $("#mail").focus();
                    alreadyFocused=true;
                }
            formValid = false;
        } else {
            if(!util.validmail(document.moduleFormContact.mail)){
                erreur.push("Votre adresse email n'est pas valide (format attendu : nomprenom@mail.com)");
                 if(!alreadyFocused){
                        $("#mail").focus();
                        alreadyFocused=true;
                    }
                formValid = false;
            }
        }
        if (typeof isCaptchaFilled !== "undefined") {
            if(!isCaptchaFilled("moduleFormContact")){
                erreur.push("Vous devez accepter le captcha");
                 if(!alreadyFocused){
                        $("[title='reCAPTCHA']").focus();
                        alreadyFocused=true;
                    }
                formValid = false;
            }
        }

        if (typeof isRgpdAccepted === 'function') {
            if(!isRgpdAccepted("moduleFormContact")) {
                erreur.push("Vous devez accepter les données RGPD du formulaire.");
                 if(!alreadyFocused){
                        $("#rgpdAccepted").focus();
                        alreadyFocused=true;
                    }
                formValid = false;
            }
        }

        if(!formValid)
            alert(erreur.join("\n"));
        else
            document.moduleFormContact.submit();
        return false;
    })
}