const util = require("./util");

if($("#submitLocationCarForm").length>0){
    $("#submitLocationCarForm").on("click",function(e) {
        e.preventDefault();
        var erreur = [];
        var formValid = true;
        let alreadyFocused=false;

        if(document.locationCar.contactnom.value===""){
            erreur.push("Vous devez préciser votre nom de famille");
            if(!alreadyFocused){
                $("#locationCarContactNom").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.contactprenom.value===""){
            erreur.push("Vous devez préciser votre prénom");
            if(!alreadyFocused){
                $("#locationCarContactPrenom").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.mail.value===""){
            erreur.push("Vous devez préciser votre e-mail (format attendu : nomprenom@mail.com)");
            if(!alreadyFocused){
                $("#locationCarMail").focus();
                alreadyFocused=true;
            }
            formValid = false;
        } else {
            if(!util.validmail(document.locationCar.mail)){
                erreur.push("Votre adresse email n'est pas valide (format attendu : nomprenom@mail.com)");
                if(!alreadyFocused){
                    $("#locationCarMail").focus();
                    alreadyFocused=true;
                }
                formValid = false;
            }
        }
        if(document.locationCar.telephone.value===""){
            erreur.push("Entrez votre numéro de téléphone");
            if(!alreadyFocused){
                $("#locationCarTelephone").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.nbpassagers.value===""){
            erreur.push("Vous devez préciser le nombre de passager (exemple:10)");
            if(!alreadyFocused){
                $("#locationCarNbPassagers").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.datedepart.value===""){
            erreur.push("Vous devez préciser une date de départ (exemple : 16/10/2021) ou utiliser le calendrier pour la sélectionner.");
            if(!alreadyFocused){
                $("#datedepart").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.dateretour.value===""){
            erreur.push("Vous devez préciser une date de retour (exemple : 16/10/2021) ou utiliser le calendrier pour la sélectionner.");
            if(!alreadyFocused){
                $("#dateretour").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.depart.value===""){
            erreur.push("Vous devez préciser une ville de départ");
            if(!alreadyFocused){
                $("#depart").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.destination.value===""){
            erreur.push("Vous devez préciser une ville de destination");
            if(!alreadyFocused){
                $("#destination").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }
        if(document.locationCar.description.value===""){
            erreur.push("Vous devez préciser une description");
            if(!alreadyFocused){
                $("#description").focus();
                alreadyFocused=true;
            }
            formValid = false;
        }

        if (typeof isRgpdAccepted === 'function') {
            if(!isRgpdAccepted("locationCar")) {
                erreur.push("Vous devez accepter les données RGPD du formulaire. ")
                if(!alreadyFocused){
                    $("#rgpdAccepted").focus();
                    alreadyFocused=true;
                }
                formValid = false;
            }
        }
        if (typeof isCaptchaFilled !== "undefined") {
            if(!isCaptchaFilled("locationCar")){
                erreur.push("Vous devez accepter le captcha");
                if(!alreadyFocused){
                        $("[title='reCAPTCHA']").focus();
                    alreadyFocused=true;
                }
                formValid = false;
            }
        }

        if(!formValid)
            alert(erreur.join("\n"));
        else
            document.locationCar.submit();
        return false;
    });
}