<?php
/**
 * Created by PhpStorm.
 * User: damien
 * Date: 10/03/2018
 * Time: 19:46
 */

namespace Actigraph\ActipageBaseBundle\Services;


use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Actigraph\ActipageBaseBundle\Services\IconCaptchaSession;

class CaptchaService
{
    private $session;
    private $captcha;

    public function __construct($params, SessionInterface $session,ContentSecurityPolicyNonceService $contentSecurityPolicyNonceService) {
        $this->session = $session;
        if(!isset($params["captcha"]) || $params["captcha"]["type"] == "none"){
            $this->captcha = new CaptchaNone($this->session,$contentSecurityPolicyNonceService,array());
        }else{
            $config = $params["captcha"]["config"];
            if($params["captcha"]["type"] == "googlerecaptcha"){
                $this->captcha = new CaptchaGoogleRecaptcha($this->session,$contentSecurityPolicyNonceService,$config);
            } elseif ($params["captcha"]["type"] == "iconCaptcha"){
                $this->captcha = new CaptchaIconCaptcha($this->session,$contentSecurityPolicyNonceService);
            } elseif ($params["captcha"]["type"] == "hcaptcha"){
                $this->captcha = new CaptchaHcaptchaService($this->session,$contentSecurityPolicyNonceService,$config);
            } elseif ($params["captcha"]["type"] == "prosopo"){
                $this->captcha = new CaptchaProsopoService($this->session,$contentSecurityPolicyNonceService,$config);
            }
        }
    }

    public function getHtmlCaptcha(){
        return $this->captcha->getHtmlCaptcha();
    }

    public function isCaptchaValid($postData){
        return $this->captcha->isCaptchaValid($postData);
    }

    public function removeCaptchaParamFromPostData($posData){
        return $this->captcha->removeCaptchaParamFromPostData($posData);
    }
}
