<?php

namespace Actigraph\ActipageBaseBundle\Services\Account;

use Doctrine\Migrations\Configuration\Exception\UnknownConfigurationValue;
use Symfony\Component\Routing\Exception\MissingMandatoryParametersException;

class AccountService
{
    private $accountMananager;

    public function __construct($params, LocalAccount $localAccount)
    {
        if (!isset($params['account'])) {
            throw new MissingMandatoryParametersException('Missing account configuration');
        }
        if (!isset($params['account']['manager'])) {
            throw new MissingMandatoryParametersException('Missing account manager configuration');
        }
        if ($params['account']['manager'] == 'local') {
            $this->accountMananager = $localAccount;
        } elseif ($params['account']['manager'] == 'ciam') {
            // SETRAM CIAM

        }

        if ($this->accountMananager === null) {
            throw new UnknownConfigurationValue('Unknown value for account manager');
        }
    }

    public function getType()
    {
        return $this->accountMananager->getType();
    }

    public function checkLogin(array $data)
    {
        return $this->accountMananager->checkLogin($data);
    }

    public function getError()
    {
        return $this->accountMananager->getError();
    }

    public function login($user)
    {
        return $this->accountMananager->login($user);
    }

    public function getUser()
    {
        return $this->accountMananager->getUser();
    }

    public function logout()
    {
        return $this->accountMananager->logout();
    }
}
