<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Site
 *
 * @ORM\Table(name="site")
 * @ORM\Entity
 */
class Site
{
    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $nom = 'Mon site';

    /**
     * @var integer
     *
     * @ORM\Column(name="langue", type="integer", nullable=false)
     */
    private $langue = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="cookie_bandeau", type="integer", nullable=false)
     */
    private $cookieBandeau = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="cookie_bandeau_boutons", type="integer", nullable=false)
     */
    private $cookieBandeauBoutons = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="restriction_ip", type="integer", nullable=false)
     */
    private $restrictionIp = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="restriction_ip_adresse", type="string", length=255, nullable=true)
     */
    private $restrictionIpAdresse;

    /**
     * @var string
     *
     * @ORM\Column(name="restriction_ip_interdire", type="string", length=255, nullable=true)
     */
    private $restrictionIpInterdire;

    /**
     * @var integer
     *
     * @ORM\Column(name="plan", type="integer", nullable=false)
     */
    private $plan = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="recherche", type="integer", nullable=false)
     */
    private $recherche = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="menu_retract", type="integer", nullable=false)
     */
    private $menuRetract;

    /**
     * @var integer
     *
     * @ORM\Column(name="newsletter", type="integer", nullable=false)
     */
    private $newsletter;

    /**
     * @var string
     *
     * @ORM\Column(name="mail", type="string", length=255, nullable=false)
     */
    private $mail;

    /**
     * @var integer
     *
     * @ORM\Column(name="rewrite", type="integer", nullable=false)
     */
    private $rewrite;

    /**
     * @var string
     *
     * @ORM\Column(name="domaine", type="string", length=250, nullable=false)
     */
    private $domaine;

    /**
     * @var integer
     *
     * @ORM\Column(name="preprod", type="integer", nullable=false)
     */
    private $preprod = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="tiny", type="integer", nullable=false)
     */
    private $tiny = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="albulle", type="integer", nullable=false)
     */
    private $albulle = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="extranet", type="integer", nullable=false)
     */
    private $extranet = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="structure", type="integer", nullable=false)
     */
    private $structure = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="agenda", type="integer", nullable=false)
     */
    private $agenda = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="actu_agenda", type="integer", nullable=false)
     */
    private $actuAgenda = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="page_newsletter", type="string", length=100, nullable=false)
     */
    private $pageNewsletter;

    /**
     * @var integer
     *
     * @ORM\Column(name="GoogleAnalytics", type="integer", nullable=false)
     */
    private $googleanalytics;

    /**
     * @var string
     *
     * @ORM\Column(name="ga_email", type="string", length=100, nullable=false)
     */
    private $gaEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="ga_password", type="string", length=50, nullable=false)
     */
    private $gaPassword;

    /**
     * @var string
     *
     * @ORM\Column(name="ga_profile_id", type="string", length=50, nullable=false)
     */
    private $gaProfileId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="page_share", type="boolean", nullable=false)
     */
    private $pageShare;

    /**
     * @var boolean
     *
     * @ORM\Column(name="actu_share", type="boolean", nullable=false)
     */
    private $actuShare;

    /**
     * @var boolean
     *
     * @ORM\Column(name="admin_actu_share", type="boolean", nullable=false)
     */
    private $adminActuShare;

    /**
     * @var integer
     *
     * @ORM\Column(name="editeur_image_advanced", type="integer", nullable=false)
     */
    private $editeurImageAdvanced = '0';

    /**
     * @var boolean
     *
     * @ORM\Column(name="site_mobile", type="boolean", nullable=false)
     */
    private $siteMobile;

    /**
     * @var boolean
     *
     * @ORM\Column(name="detection_mobile", type="boolean", nullable=false)
     */
    private $detectionMobile;

    /**
     * @var string
     *
     * @ORM\Column(name="domaine_mobile", type="text", nullable=false)
     */
    private $domaineMobile;

    /**
     * @var boolean
     *
     * @ORM\Column(name="choix_mobile", type="boolean", nullable=false)
     */
    private $choixMobile;

    /**
     * @var boolean
     *
     * @ORM\Column(name="accueil_mobile_liste", type="boolean", nullable=false)
     */
    private $accueilMobileListe;

    /**
     * @var boolean
     *
     * @ORM\Column(name="menutop_mobile", type="boolean", nullable=false)
     */
    private $menutopMobile;

    /**
     * @var boolean
     *
     * @ORM\Column(name="menutop_mobile_pictos_perso", type="boolean", nullable=false)
     */
    private $menutopMobilePictosPerso;

    /**
     * @var string
     *
     * @ORM\Column(name="mobile_pictos_perso_prefix", type="string", length=255, nullable=false)
     */
    private $mobilePictosPersoPrefix;

    /**
     * @var boolean
     *
     * @ORM\Column(name="menu_langue_mobile", type="boolean", nullable=false)
     */
    private $menuLangueMobile;

    /**
     * @var boolean
     *
     * @ORM\Column(name="traduction_page_mobile", type="boolean", nullable=false)
     */
    private $traductionPageMobile;

    /**
     * @var boolean
     *
     * @ORM\Column(name="traduction_page_site", type="boolean", nullable=false)
     */
    private $traductionPageSite;

    /**
     * @return boolean
     */
    public function isAccueilMobileListe()
    {
        return $this->accueilMobileListe;
    }

    /**
     * @param boolean $accueilMobileListe
     */
    public function setAccueilMobileListe($accueilMobileListe)
    {
        $this->accueilMobileListe = $accueilMobileListe;
    }

    /**
     * @return int
     */
    public function getActuAgenda()
    {
        return $this->actuAgenda;
    }

    /**
     * @param int $actuAgenda
     */
    public function setActuAgenda($actuAgenda)
    {
        $this->actuAgenda = $actuAgenda;
    }

    /**
     * @return boolean
     */
    public function isActuShare()
    {
        return $this->actuShare;
    }

    /**
     * @param boolean $actuShare
     */
    public function setActuShare($actuShare)
    {
        $this->actuShare = $actuShare;
    }

    /**
     * @return boolean
     */
    public function isAdminActuShare()
    {
        return $this->adminActuShare;
    }

    /**
     * @param boolean $adminActuShare
     */
    public function setAdminActuShare($adminActuShare)
    {
        $this->adminActuShare = $adminActuShare;
    }

    /**
     * @return int
     */
    public function getAgenda()
    {
        return $this->agenda;
    }

    /**
     * @param int $agenda
     */
    public function setAgenda($agenda)
    {
        $this->agenda = $agenda;
    }

    /**
     * @return int
     */
    public function getAlbulle()
    {
        return $this->albulle;
    }

    /**
     * @param int $albulle
     */
    public function setAlbulle($albulle)
    {
        $this->albulle = $albulle;
    }

    /**
     * @return boolean
     */
    public function isChoixMobile()
    {
        return $this->choixMobile;
    }

    /**
     * @param boolean $choixMobile
     */
    public function setChoixMobile($choixMobile)
    {
        $this->choixMobile = $choixMobile;
    }

    /**
     * @return boolean
     */
    public function isDetectionMobile()
    {
        return $this->detectionMobile;
    }

    /**
     * @param boolean $detectionMobile
     */
    public function setDetectionMobile($detectionMobile)
    {
        $this->detectionMobile = $detectionMobile;
    }

    /**
     * @return string
     */
    public function getDomaine()
    {
        return $this->domaine;
    }

    /**
     * @param string $domaine
     */
    public function setDomaine($domaine)
    {
        $this->domaine = $domaine;
    }

    /**
     * @return string
     */
    public function getDomaineMobile()
    {
        return $this->domaineMobile;
    }

    /**
     * @param string $domaineMobile
     */
    public function setDomaineMobile($domaineMobile)
    {
        $this->domaineMobile = $domaineMobile;
    }

    /**
     * @return int
     */
    public function getEditeurImageAdvanced()
    {
        return $this->editeurImageAdvanced;
    }

    /**
     * @param int $editeurImageAdvanced
     */
    public function setEditeurImageAdvanced($editeurImageAdvanced)
    {
        $this->editeurImageAdvanced = $editeurImageAdvanced;
    }

    /**
     * @return int
     */
    public function getExtranet()
    {
        return $this->extranet;
    }

    /**
     * @param int $extranet
     */
    public function setExtranet($extranet)
    {
        $this->extranet = $extranet;
    }

    /**
     * @return string
     */
    public function getGaEmail()
    {
        return $this->gaEmail;
    }

    /**
     * @param string $gaEmail
     */
    public function setGaEmail($gaEmail)
    {
        $this->gaEmail = $gaEmail;
    }

    /**
     * @return string
     */
    public function getGaPassword()
    {
        return $this->gaPassword;
    }

    /**
     * @param string $gaPassword
     */
    public function setGaPassword($gaPassword)
    {
        $this->gaPassword = $gaPassword;
    }

    /**
     * @return string
     */
    public function getGaProfileId()
    {
        return $this->gaProfileId;
    }

    /**
     * @param string $gaProfileId
     */
    public function setGaProfileId($gaProfileId)
    {
        $this->gaProfileId = $gaProfileId;
    }

    /**
     * @return int
     */
    public function getGoogleanalytics()
    {
        return $this->googleanalytics;
    }

    /**
     * @param int $googleanalytics
     */
    public function setGoogleanalytics($googleanalytics)
    {
        $this->googleanalytics = $googleanalytics;
    }

    /**
     * @return int
     */
    public function getLangue()
    {
        return $this->langue;
    }

    /**
     * @param int $langue
     */
    public function setLangue($langue)
    {
        $this->langue = $langue;
    }

    /**
     * @return string
     */
    public function getMail()
    {
        return $this->mail;
    }

    /**
     * @param string $mail
     */
    public function setMail($mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return boolean
     */
    public function isMenuLangueMobile()
    {
        return $this->menuLangueMobile;
    }

    /**
     * @param boolean $menuLangueMobile
     */
    public function setMenuLangueMobile($menuLangueMobile)
    {
        $this->menuLangueMobile = $menuLangueMobile;
    }

    /**
     * @return int
     */
    public function getMenuRetract()
    {
        return $this->menuRetract;
    }

    /**
     * @param int $menuRetract
     */
    public function setMenuRetract($menuRetract)
    {
        $this->menuRetract = $menuRetract;
    }

    /**
     * @return boolean
     */
    public function isMenutopMobile()
    {
        return $this->menutopMobile;
    }

    /**
     * @param boolean $menutopMobile
     */
    public function setMenutopMobile($menutopMobile)
    {
        $this->menutopMobile = $menutopMobile;
    }

    /**
     * @return boolean
     */
    public function isMenutopMobilePictosPerso()
    {
        return $this->menutopMobilePictosPerso;
    }

    /**
     * @param boolean $menutopMobilePictosPerso
     */
    public function setMenutopMobilePictosPerso($menutopMobilePictosPerso)
    {
        $this->menutopMobilePictosPerso = $menutopMobilePictosPerso;
    }

    /**
     * @return string
     */
    public function getMobilePictosPersoPrefix()
    {
        return $this->mobilePictosPersoPrefix;
    }

    /**
     * @param string $mobilePictosPersoPrefix
     */
    public function setMobilePictosPersoPrefix($mobilePictosPersoPrefix)
    {
        $this->mobilePictosPersoPrefix = $mobilePictosPersoPrefix;
    }

    /**
     * @return int
     */
    public function getNewsletter()
    {
        return $this->newsletter;
    }

    /**
     * @param int $newsletter
     */
    public function setNewsletter($newsletter)
    {
        $this->newsletter = $newsletter;
    }

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @return string
     */
    public function getPageNewsletter()
    {
        return $this->pageNewsletter;
    }

    /**
     * @param string $pageNewsletter
     */
    public function setPageNewsletter($pageNewsletter)
    {
        $this->pageNewsletter = $pageNewsletter;
    }

    /**
     * @return boolean
     */
    public function isPageShare()
    {
        return $this->pageShare;
    }

    /**
     * @param boolean $pageShare
     */
    public function setPageShare($pageShare)
    {
        $this->pageShare = $pageShare;
    }

    /**
     * @return int
     */
    public function getPlan()
    {
        return $this->plan;
    }

    /**
     * @param int $plan
     */
    public function setPlan($plan)
    {
        $this->plan = $plan;
    }

    /**
     * @return int
     */
    public function getPreprod()
    {
        return $this->preprod;
    }

    /**
     * @param int $preprod
     */
    public function setPreprod($preprod)
    {
        $this->preprod = $preprod;
    }

    /**
     * @return int
     */
    public function getRecherche()
    {
        return $this->recherche;
    }

    /**
     * @param int $recherche
     */
    public function setRecherche($recherche)
    {
        $this->recherche = $recherche;
    }

    /**
     * @return int
     */
    public function getRewrite()
    {
        return $this->rewrite;
    }

    /**
     * @param int $rewrite
     */
    public function setRewrite($rewrite)
    {
        $this->rewrite = $rewrite;
    }

    /**
     * @return boolean
     */
    public function isSiteMobile()
    {
        return $this->siteMobile;
    }

    /**
     * @param boolean $siteMobile
     */
    public function setSiteMobile($siteMobile)
    {
        $this->siteMobile = $siteMobile;
    }

    /**
     * @return int
     */
    public function getStructure()
    {
        return $this->structure;
    }

    /**
     * @param int $structure
     */
    public function setStructure($structure)
    {
        $this->structure = $structure;
    }

    /**
     * @return int
     */
    public function getTiny()
    {
        return $this->tiny;
    }

    /**
     * @param int $tiny
     */
    public function setTiny($tiny)
    {
        $this->tiny = $tiny;
    }

    /**
     * @return boolean
     */
    public function isTraductionPageMobile()
    {
        return $this->traductionPageMobile;
    }

    /**
     * @param boolean $traductionPageMobile
     */
    public function setTraductionPageMobile($traductionPageMobile)
    {
        $this->traductionPageMobile = $traductionPageMobile;
    }

    /**
     * @return boolean
     */
    public function isTraductionPageSite()
    {
        return $this->traductionPageSite;
    }

    /**
     * @param boolean $traductionPageSite
     */
    public function setTraductionPageSite($traductionPageSite)
    {
        $this->traductionPageSite = $traductionPageSite;
    }


    public function getPublicURL($type = null)
    {
        if($type == "site")
            return $this->getDomaine();
        else if($type == "mobile"){
            if($this->getDomaineMobile() != null)
                return $this->getDomaineMobile();
            else
                return $this->getDomaine();
        }
        return null;
    }

    public function getDisplayName($type = null)
    {
        // TODO: Implement getDisplayName() method.
        return $this->getPublicURL($type);
    }

    public function getId($type = null)
    {
        // TODO: Implement getId() method.
        return $this->getNom();
    }

    public function getType()
    {
        return false;
    }

    /**
     * @return int
     */
    public function getCookieBandeau()
    {
        return $this->cookieBandeau;
    }

    /**
     * @param int $cookieBandeau
     */
    public function setCookieBandeau($cookieBandeau)
    {
        $this->cookieBandeau = $cookieBandeau;
    }

    /**
     * @return int
     */
    public function getCookieBandeauBoutons()
    {
        return $this->cookieBandeauBoutons;
    }

    /**
     * @param int $cookieBandeauBoutons
     */
    public function setCookieBandeauBoutons($cookieBandeauBoutons)
    {
        $this->cookieBandeauBoutons = $cookieBandeauBoutons;
    }

    /**
     * @return int
     */
    public function getRestrictionIp()
    {
        return $this->restrictionIp;
    }

    /**
     * @param int $restrictionIp
     */
    public function setRestrictionIp($restrictionIp)
    {
        $this->restrictionIp = $restrictionIp;
    }

    /**
     * @return string
     */
    public function getRestrictionIpAdresse()
    {
        return $this->restrictionIpAdresse;
    }

    /**
     * @param string $restrictionIpAdresse
     */
    public function setRestrictionIpAdresse($restrictionIpAdresse)
    {
        $this->restrictionIpAdresse = $restrictionIpAdresse;
    }

    /**
     * @return string
     */
    public function getRestrictionIpInterdire()
    {
        return $this->restrictionIpInterdire;
    }

    /**
     * @param string $restrictionIpInterdire
     */
    public function setRestrictionIpInterdire($restrictionIpInterdire)
    {
        $this->restrictionIpInterdire = $restrictionIpInterdire;
    }

}
