<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Newsletters
 *
 * @ORM\Table(name="newsletters")
 * @ORM\Entity
 */
class Newsletters
{
    /**
     * @var integer
     *
     * @ORM\Column(name="newsletter_id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $newsletterId;

    /**
     * @var string
     * @Assert\NotBlank(message="Vous devez définir un objet")
     * @ORM\Column(name="newsletter_objet", type="text", nullable=false)
     */
    private $newsletterObjet;

    /**
     * @var string
     * @Assert\NotBlank(message="Vous devez définir un contenu")
     * @ORM\Column(name="newsletter_contenu_html", type="text", nullable=false)
     */
    private $newsletterContenuHtml;

    /**
     * @var string
     *
     * @ORM\Column(name="newsletter_contenu_text", type="text", nullable=false)
     */
    private $newsletterContenuText;

    /**
     * @var string
     *
     * @ORM\Column(name="newsletter_date_last_envoi", type="text", nullable=false)
     */
    private $newsletterDateLastEnvoi;

    /**
     * @var boolean
     *
     * @ORM\Column(name="newsletter_envoyee", type="boolean", nullable=false)
     */
    private $newsletterEnvoyee;

    /**
     * @ORM\OneToOne(targetEntity="Actigraph\ActipageBaseBundle\Entity\NewsletterStats", mappedBy="newsletter", cascade={"remove"})
     **/
    private $stat;

    /**
     * @var integer
     *
     * @ORM\Column(name="newsletter_langue", type="integer", nullable=false)
     */
    private $newsletterLangue;

    /**
     * @var integer
     *
     * @ORM\Column(name="newsletter_creation_date", type="bigint", nullable=false)
     */
    private $newsletterCreationDate;

    /**
     * @var string
     *
     * @ORM\Column(name="newsletter_last_modification", type="text", nullable=false)
     */
    private $newsletterLastModification;

    /**
     * @var integer
     *
     * @ORM\Column(name="newsletter_envoi_diff_date", type="bigint", nullable=false)
     */
    private $newsletterEnvoiDiffDate;

    /**
     * @var string
     *
     * @ORM\Column(name="newsletter_envoi_diff_groupes", type="text", nullable=false)
     */
    private $newsletterEnvoiDiffGroupes;
    /**
     * @var boolean
     *
     * @ORM\Column(name="newsletter_envoi_en_cours", type="boolean", nullable=false)
     */
    private $newsletterEnvoiEnCours = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="newsletter_nom", type="string", length=255, nullable=false)
     */
    private $newsletterNom;

    /**
     * @var string
     *
     * @ORM\Column(name="newsletter_envoi_diff_requetes", type="text", nullable=false)
     */
    private $newsletterEnvoiDiffRequetes;

    /**
     * @return string
     */
    public function getNewsletterContenuHtml()
    {
        return $this->newsletterContenuHtml;
    }

    /**
     * @param string $newsletterContenuHtml
     */
    public function setNewsletterContenuHtml($newsletterContenuHtml)
    {
        $this->newsletterContenuHtml = $newsletterContenuHtml;
    }

    /**
     * @return string
     */
    public function getNewsletterContenuText()
    {
        return $this->newsletterContenuText;
    }

    /**
     * @param string $newsletterContenuText
     */
    public function setNewsletterContenuText($newsletterContenuText)
    {
        $this->newsletterContenuText = $newsletterContenuText;
    }

    /**
     * @return int
     */
    public function getNewsletterCreationDate()
    {
        return $this->newsletterCreationDate;
    }

    /**
     * @param int $newsletterCreationDate
     */
    public function setNewsletterCreationDate($newsletterCreationDate)
    {
        $this->newsletterCreationDate = $newsletterCreationDate;
    }

    /**
     * @return string
     */
    public function getNewsletterDateLastEnvoi()
    {
        return $this->newsletterDateLastEnvoi;
    }

    /**
     * @param string $newsletterDateLastEnvoi
     */
    public function setNewsletterDateLastEnvoi($newsletterDateLastEnvoi)
    {
        $this->newsletterDateLastEnvoi = $newsletterDateLastEnvoi;
    }

    /**
     * @return int
     */
    public function getNewsletterEnvoiDiffDate()
    {
        return $this->newsletterEnvoiDiffDate;
    }

    /**
     * @param int $newsletterEnvoiDiffDate
     */
    public function setNewsletterEnvoiDiffDate($newsletterEnvoiDiffDate)
    {
        $this->newsletterEnvoiDiffDate = $newsletterEnvoiDiffDate;
    }

    /**
     * @return string
     */
    public function getNewsletterEnvoiDiffGroupes()
    {
        return $this->newsletterEnvoiDiffGroupes;
    }

    /**
     * @param string $newsletterEnvoiDiffGroupes
     */
    public function setNewsletterEnvoiDiffGroupes($newsletterEnvoiDiffGroupes)
    {
        $this->newsletterEnvoiDiffGroupes = $newsletterEnvoiDiffGroupes;
    }

    /**
     * @return string
     */
    public function getNewsletterEnvoiDiffRequetes()
    {
        return $this->newsletterEnvoiDiffRequetes;
    }

    /**
     * @param string $newsletterEnvoiDiffRequetes
     */
    public function setNewsletterEnvoiDiffRequetes($newsletterEnvoiDiffRequetes)
    {
        $this->newsletterEnvoiDiffRequetes = $newsletterEnvoiDiffRequetes;
    }

    /**
     * @return boolean
     */
    public function getNewsletterEnvoiEnCours()
    {
        return $this->newsletterEnvoiEnCours;
    }

    /**
     * @param boolean $newsletterEnvoiEnCours
     */
    public function setNewsletterEnvoiEnCours($newsletterEnvoiEnCours)
    {
        $this->newsletterEnvoiEnCours = $newsletterEnvoiEnCours;
    }

    /**
     * @return boolean
     */
    public function getNewsletterEnvoyee()
    {
        return $this->newsletterEnvoyee;
    }

    /**
     * @param boolean $newsletterEnvoyee
     */
    public function setNewsletterEnvoyee($newsletterEnvoyee)
    {
        $this->newsletterEnvoyee = $newsletterEnvoyee;
    }

    /**
     * @return int
     */
    public function getNewsletterId()
    {
        return $this->newsletterId;
    }

    /**
     * @param int $newsletterId
     */
    public function setNewsletterId($newsletterId)
    {
        $this->newsletterId = $newsletterId;
    }

    /**
     * @return int
     */
    public function getNewsletterLangue()
    {
        return $this->newsletterLangue;
    }

    /**
     * @param int $newsletterLangue
     */
    public function setNewsletterLangue($newsletterLangue)
    {
        $this->newsletterLangue = $newsletterLangue;
    }

    /**
     * @return string
     */
    public function getNewsletterLastModification()
    {
        return $this->newsletterLastModification;
    }

    /**
     * @param string $newsletterLastModification
     */
    public function setNewsletterLastModification($newsletterLastModification)
    {
        $this->newsletterLastModification = $newsletterLastModification;
    }

    /**
     * @return string
     */
    public function getNewsletterNom()
    {
        return $this->newsletterNom;
    }

    /**
     * @param string $newsletterNom
     */
    public function setNewsletterNom($newsletterNom)
    {
        $this->newsletterNom = $newsletterNom;
    }

    /**
     * @return string
     */
    public function getNewsletterObjet()
    {
        return $this->newsletterObjet;
    }

    /**
     * @param string $newsletterObjet
     */
    public function setNewsletterObjet($newsletterObjet)
    {
        $this->newsletterObjet = $newsletterObjet;
    }

    /**
     * @return mixed
     */
    public function getStat()
    {
        return $this->stat;
    }

    /**
     * @param mixed $stat
     */
    public function setStat($stat)
    {
        $this->stat = $stat;
    }


}
