<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Langues
 *
 * @ORM\Table(name="langues")
 * @ORM\Entity
 */
class Langues
{
    /**
     * @var integer
     *
     * @ORM\Column(name="langue_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $langueId;

    /**
     * @var string
     *
     * @ORM\Column(name="langue_lib", type="string", length=50, nullable=false)
     */
    private $langueLib = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="extranet", type="integer", nullable=false)
     */
    private $extranet = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="langue_mere", type="integer", nullable=false)
     */
    private $langueMere = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="langue_shortcode", type="string", length=5, nullable=false)
     */
    private $langueShortCode = '';

    /**
     * @var string
     *
     * @ORM\Column(name="langue_shortcode_ref", type="string", length=5, nullable=false)
     */
    private $langueShortCodeRef = '';

    /**
     * @return int
     */
    public function getExtranet()
    {
        return $this->extranet;
    }

    /**
     * @param int $extranet
     */
    public function setExtranet($extranet)
    {
        $this->extranet = $extranet;
    }

    /**
     * @return int
     */
    public function getLangueId()
    {
        return $this->langueId;
    }

    /**
     * @return string
     */
    public function getLangueLib()
    {
        return $this->langueLib;
    }

    /**
     * @param string $langueLib
     */
    public function setLangueLib($langueLib)
    {
        $this->langueLib = $langueLib;
    }

    /**
     * @return int
     */
    public function getLangueMere()
    {
        return $this->langueMere;
    }

    /**
     * @param int $langueMere
     */
    public function setLangueMere($langueMere)
    {
        $this->langueMere = $langueMere;
    }

    /**
     * @return string
     */
    public function getLangueShortCode()
    {
        return $this->langueShortCode;
    }

    /**
     * @param string $langueShortCode
     */
    public function setLangueShortCode($langueShortCode)
    {
        $this->langueShortCode = $langueShortCode;
    }

    public function getLangueShortClassName(){
        $nom = $this->getLangueLib();
        $tmp = explode(" ",$nom);
        if(count($tmp) > 1)
            $nom = end($tmp);
        return strtolower(substr($nom,0,3));
    }

    /**
     * @return string
     */
    public function getLangueShortCodeRef()
    {
        return $this->langueShortCodeRef;
    }

    /**
     * @param string $langueShortCodeRef
     */
    public function setLangueShortCodeRef($langueShortCodeRef)
    {
        $this->langueShortCodeRef = $langueShortCodeRef;
    }
}
