<?php

namespace Actigraph\ActipageBaseBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Actus
 *
 * @ORM\Table(name="actus")
 * @ORM\Entity
 */
class Actus
{
    /**
     * @var integer
     *
     * @ORM\Column(name="actu_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $actuId;

    /**
     * @var string
     * @Assert\NotBlank(message="Vous devez définir un titre")
     * @ORM\Column(name="actu_titre", type="string", length=255, nullable=false)
     */
    private $actuTitre = '';

    /**
     * @var string
     * @Assert\NotBlank(message="Vous devez définir un titre d'accroche")
     * @ORM\Column(name="actu_accroche", type="string", length=255, nullable=false)
     */
    private $actuAccroche = '';

    /**
     * @var string
     *
     * @ORM\Column(name="actu_texte", type="text", nullable=false)
     */
    private $actuTexte;

    /**
     * @var string
     *
     * @ORM\Column(name="actu_lien", type="string", length=255, nullable=false)
     */
    private $actuLien = '';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="actu_date_deb", type="datetime", nullable=false)
     */
    private $actuDateDeb;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="actu_date_fin", type="datetime", nullable=false)
     */
    private $actuDateFin;

    /**
     * @var integer
     *
     * @ORM\Column(name="actu_alerte", type="integer", nullable=false)
     */
    private $actuAlerte = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="actu_lang", type="integer", nullable=false)
     */
    private $actuLang = '1';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="actu_date_envoi", type="date", nullable=false)
     */
    private $actuDateEnvoi = '0000-00-00';

    /**
     * @var string
     *
     * @ORM\Column(name="actu_image", type="string", length=255, nullable=false)
     */
    private $actuImage;

    /**
     * @var integer
     * @ORM\Column(name="id_type_actu", type="integer", nullable=false)
     */
    private $idTypeActu = '0';

    /**
     * @ORM\ManyToOne(targetEntity="Actigraph\ActipageBaseBundle\Entity\TypeActu", inversedBy="actus" )
     * @ORM\JoinColumn(name="id_type_actu", referencedColumnName="id_type_actu")
     */
    private $typeActu;

    /**
     * @var integer
     * @ORM\Column(name="id_gravite_actu", type="integer", nullable=false)
     */
    private $idGraviteActu = '0';

    /**
     * @ORM\ManyToOne(targetEntity="Actigraph\ActipageBaseBundle\Entity\GraviteActu", inversedBy="actus" )
     * @ORM\JoinColumn(name="id_gravite_actu", referencedColumnName="id")
     */
    private $graviteActu;

    /**
     * @ORM\ManyToMany(targetEntity="Actigraph\ActipageBaseBundle\Entity\Lignes", mappedBy="actus", fetch="EAGER")
     * @ORM\JoinTable(
     *     name="actus_lignes",
     *     joinColumns={@ORM\JoinColumn(name="actu_id", referencedColumnName="actu_id")},
     *     inverseJoinColumns={@ORM\JoinColumn(name="LineExternalCode", referencedColumnName="LineExternalCode")}
     * )
     */
    private $lignes;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="actu_date_deb_eve", type="datetime", nullable=false)
     */
    private $actuDateDebEve = '0000-00-00 00:00:00';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="actu_date_fin_eve", type="datetime", nullable=false)
     */
    private $actuDateFinEve = '0000-00-00 00:00:00';

    /**
     * @var integer
     *
     * @ORM\Column(name="id_structure", type="integer", nullable=false)
     */
    private $idStructure = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="agenda", type="integer", nullable=false)
     */
    private $agenda = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="titre_newsletter", type="string", length=255, nullable=false)
     */
    private $titreNewsletter;

    /**
     * @var integer
     *
     * @ORM\Column(name="actu_lien_cible", type="integer", nullable=false)
     */
    private $actuLienCible = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="brouillon_texte", type="text", nullable=false)
     */
    private $brouillonTexte;

    /**
     * @var integer
     *
     * @ORM\Column(name="brouillon_valide", type="integer", nullable=false)
     */
    private $brouillonValide = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="plage_horaire", type="text", nullable=true)
     */

    private $plageHoraire;

    /**
     * @return string
     */
    public function getActuAccroche()
    {
        return $this->actuAccroche;
    }

    /**
     * @param string $actuAccroche
     */
    public function setActuAccroche($actuAccroche)
    {
        $this->actuAccroche = $actuAccroche;
    }

    /**
     * @return int
     */
    public function getActuAlerte()
    {
        return $this->actuAlerte;
    }

    /**
     * @param int $actuAlerte
     */
    public function setActuAlerte($actuAlerte)
    {
        $this->actuAlerte = $actuAlerte;
    }

    /**
     * @return \DateTime
     */
    public function getActuDateDeb()
    {
        return $this->actuDateDeb;
    }

    /**
     * @param \DateTime $actuDateDeb
     */
    public function setActuDateDeb($actuDateDeb)
    {
        $this->actuDateDeb = $actuDateDeb;
    }

    /**
     * @return \DateTime
     */
    public function getActuDateDebEve()
    {
        return $this->actuDateDebEve;
    }

    /**
     * @param \DateTime $actuDateDebEve
     */
    public function setActuDateDebEve($actuDateDebEve)
    {
        $this->actuDateDebEve = $actuDateDebEve;
    }

    /**
     * @return \DateTime
     */
    public function getActuDateEnvoi()
    {
        return $this->actuDateEnvoi;
    }

    /**
     * @param \DateTime $actuDateEnvoi
     */
    public function setActuDateEnvoi($actuDateEnvoi)
    {
        $this->actuDateEnvoi = $actuDateEnvoi;
    }

    /**
     * @return \DateTime
     */
    public function getActuDateFin()
    {
        return $this->actuDateFin;
    }

    /**
     * @param \DateTime $actuDateFin
     */
    public function setActuDateFin($actuDateFin)
    {
        $this->actuDateFin = $actuDateFin;
    }

    /**
     * @return \DateTime
     */
    public function getActuDateFinEve()
    {
        return $this->actuDateFinEve;
    }

    /**
     * @param \DateTime $actuDateFinEve
     */
    public function setActuDateFinEve($actuDateFinEve)
    {
        $this->actuDateFinEve = $actuDateFinEve;
    }

    /**
     * @return int
     */
    public function getActuId()
    {
        return $this->actuId;
    }

    /**
     * @param int $actuId
     */
    public function setActuId($actuId)
    {
        $this->actuId = $actuId;
    }

    /**
     * @return string
     */
    public function getActuImage()
    {
        return $this->actuImage;
    }

    /**
     * @param string $actuImage
     */
    public function setActuImage($actuImage)
    {
        $this->actuImage = $actuImage;
    }

    /**
     * @return int
     */
    public function getActuLang()
    {
        return $this->actuLang;
    }

    /**
     * @param int $actuLang
     */
    public function setActuLang($actuLang)
    {
        $this->actuLang = $actuLang;
    }

    /**
     * @return string
     */
    public function getActuLien()
    {
        return $this->actuLien;
    }

    /**
     * @param string $actuLien
     */
    public function setActuLien($actuLien)
    {
        $this->actuLien = $actuLien;
    }

    /**
     * @return int
     */
    public function getActuLienCible()
    {
        return $this->actuLienCible;
    }

    /**
     * @param int $actuLienCible
     */
    public function setActuLienCible($actuLienCible)
    {
        $this->actuLienCible = $actuLienCible;
    }

    /**
     * @return string
     */
    public function getActuTexte()
    {
        return $this->actuTexte;
    }

    /**
     * @param string $actuTexte
     */
    public function setActuTexte($actuTexte)
    {
        $this->actuTexte = $actuTexte;
    }

    /**
     * @return string
     */
    public function getActuTitre()
    {
        return $this->actuTitre;
    }

    /**
     * @param string $actuTitre
     */
    public function setActuTitre($actuTitre)
    {
        $this->actuTitre = $actuTitre;
    }

    /**
     * @return int
     */
    public function getAgenda()
    {
        return $this->agenda;
    }

    /**
     * @param int $agenda
     */
    public function setAgenda($agenda)
    {
        $this->agenda = $agenda;
    }

    /**
     * @return string
     */
    public function getBrouillonTexte()
    {
        return $this->brouillonTexte;
    }

    /**
     * @param string $brouillonTexte
     */
    public function setBrouillonTexte($brouillonTexte)
    {
        $this->brouillonTexte = $brouillonTexte;
    }

    /**
     * @return int
     */
    public function getBrouillonValide()
    {
        return $this->brouillonValide;
    }

    /**
     * @param int $brouillonValide
     */
    public function setBrouillonValide($brouillonValide)
    {
        $this->brouillonValide = $brouillonValide;
    }

    /**
     * @return int
     */
    public function getIdStructure()
    {
        return $this->idStructure;
    }

    /**
     * @param int $idStructure
     */
    public function setIdStructure($idStructure)
    {
        $this->idStructure = $idStructure;
    }

    /**
     * @return mixed
     */
    public function getIdTypeActu()
    {
        return $this->idTypeActu;
    }

    /**
     * @param mixed $idTypeActu
     */
    public function setIdTypeActu($idTypeActu)
    {
        $this->idTypeActu = $idTypeActu;
    }

    /**
     * @return string
     */
    public function getTitreNewsletter()
    {
        return $this->titreNewsletter;
    }

    /**
     * @param string $titreNewsletter
     */
    public function setTitreNewsletter($titreNewsletter)
    {
        $this->titreNewsletter = $titreNewsletter;
    }

    /**
     * @return mixed
     */
    public function getTypeActu()
    {
        return $this->typeActu;
    }

    /**
     * @param mixed $typeActu
     */
    public function setTypeActu($typeActu)
    {
        $this->typeActu = $typeActu;
    }

    /**
     * @return mixed
     */
    public function getLignes()
    {
        return $this->lignes;
    }

    /**
     * @param mixed $lignes
     */
    public function setLignes($lignes)
    {
        $this->lignes = $lignes;
    }

    /***
     * Permet de savoir si c'est une actu en cours (vis à vis des dates)
     * @return bool actualité en cours
     */
    public function isEncours(){
        $maintenant = new \DateTime;
        if ($this->actuDateDeb < $maintenant && $this->actuDateFin > $maintenant)
            return true;
        return false;
    }

    /***
     * Permet de savoir si c'est une actu en archive (vis à vis des dates)
     * @return bool actualité en cours
     */
    public function isArchive(){
        $maintenant = new \DateTime;
        if ($this->actuDateFin < $maintenant)
            return true;
        return false;
    }

    /***
     * Permet de savoir si c'est une actu a venir (vis à vis des dates)
     * @return bool actualité en cours
     */
    public function isAVenir(){
        $maintenant = new \DateTime;
        if ($this->actuDateDeb > $maintenant)
            return true;
        return false;
    }

    /**
     * @return mixed
     */
    public function getIdGraviteActu()
    {
        return $this->idGraviteActu;
    }

    /**
     * @param mixed $idGraviteActu
     */
    public function setIdGraviteActu($idGraviteActu)
    {
        $this->idGraviteActu = $idGraviteActu;
    }

    /**
     * @return mixed
     */
    public function getGraviteActu()
    {
        return $this->graviteActu;
    }

    /**
     * @param mixed $graviteActu
     */
    public function setGraviteActu($graviteActu)
    {
        $this->graviteActu = $graviteActu;
    }

    /**
     * @return string
     */
    public function getPlageHoraire()
    {
        return $this->plageHoraire;
    }

    /**
     * @param string $plageHoraire
     */
    public function setPlageHoraire($plageHoraire)
    {
        $this->plageHoraire = $plageHoraire;
    }
}
